@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RuleEvaluationModeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode The mode of an evaluation.
 */
public data class RuleEvaluationModeArgs(
    public val mode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RuleEvaluationModeArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RuleEvaluationModeArgs =
        com.pulumi.aws.cfg.inputs.RuleEvaluationModeArgs.builder()
            .mode(mode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleEvaluationModeArgs].
 */
@PulumiTagMarker
public class RuleEvaluationModeArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value The mode of an evaluation.
     */
    @JvmName("meqowcqtnebwtdiw")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The mode of an evaluation.
     */
    @JvmName("kbgywfatttvtfcdd")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): RuleEvaluationModeArgs = RuleEvaluationModeArgs(
        mode = mode,
    )
}
