@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RuleSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customPolicyDetails Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
 * @property owner Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/evaluate-config_use-managed-rules&#46;html)&#46; For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `aws.lambda.Permission` resource.
 * @property sourceDetails Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
 * @property sourceIdentifier For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `aws.lambda.Function` resource.
 */
public data class RuleSourceArgs(
    public val customPolicyDetails: Output<RuleSourceCustomPolicyDetailsArgs>? = null,
    public val owner: Output<String>,
    public val sourceDetails: Output<List<RuleSourceSourceDetailArgs>>? = null,
    public val sourceIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RuleSourceArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RuleSourceArgs =
        com.pulumi.aws.cfg.inputs.RuleSourceArgs.builder()
            .customPolicyDetails(
                customPolicyDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .owner(owner.applyValue({ args0 -> args0 }))
            .sourceDetails(
                sourceDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceIdentifier(sourceIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleSourceArgs].
 */
@PulumiTagMarker
public class RuleSourceArgsBuilder internal constructor() {
    private var customPolicyDetails: Output<RuleSourceCustomPolicyDetailsArgs>? = null

    private var owner: Output<String>? = null

    private var sourceDetails: Output<List<RuleSourceSourceDetailArgs>>? = null

    private var sourceIdentifier: Output<String>? = null

    /**
     * @param value Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
     */
    @JvmName("bsaqacmonrueshxo")
    public suspend fun customPolicyDetails(`value`: Output<RuleSourceCustomPolicyDetailsArgs>) {
        this.customPolicyDetails = value
    }

    /**
     * @param value Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/evaluate-config_use-managed-rules&#46;html)&#46; For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `aws.lambda.Permission` resource.
     */
    @JvmName("tmotrlfkrsvgkpcs")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("eriueodtxevnjbqw")
    public suspend fun sourceDetails(`value`: Output<List<RuleSourceSourceDetailArgs>>) {
        this.sourceDetails = value
    }

    @JvmName("revewlmwgpolnaik")
    public suspend fun sourceDetails(vararg values: Output<RuleSourceSourceDetailArgs>) {
        this.sourceDetails = Output.all(values.asList())
    }

    /**
     * @param values Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("kibjmkcfgulwrlna")
    public suspend fun sourceDetails(values: List<Output<RuleSourceSourceDetailArgs>>) {
        this.sourceDetails = Output.all(values)
    }

    /**
     * @param value For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `aws.lambda.Function` resource.
     */
    @JvmName("wbeklorcauwxwseg")
    public suspend fun sourceIdentifier(`value`: Output<String>) {
        this.sourceIdentifier = value
    }

    /**
     * @param value Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
     */
    @JvmName("pgcbcqkiylhoouje")
    public suspend fun customPolicyDetails(`value`: RuleSourceCustomPolicyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPolicyDetails = mapped
    }

    /**
     * @param argument Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to `CUSTOM_POLICY`. See Custom Policy Details Below.
     */
    @JvmName("aajklmjifmwpvbwd")
    public suspend
    fun customPolicyDetails(argument: suspend RuleSourceCustomPolicyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = RuleSourceCustomPolicyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customPolicyDetails = mapped
    }

    /**
     * @param value Indicates whether AWS or the customer owns and manages the AWS Config rule. Valid values are `AWS`, `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. For more information about managed rules, see the [AWS Config Managed Rules documentation](https://docs&#46;aws&#46;amazon&#46;com/config/latest/developerguide/evaluate-config_use-managed-rules&#46;html)&#46; For more information about custom rules, see the [AWS Config Custom Rules documentation](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html). Custom Lambda Functions require permissions to allow the AWS Config service to invoke them, e.g., via the `aws.lambda.Permission` resource.
     */
    @JvmName("nhmxmkrtvogdiuuy")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("llqqkfkvmbcjcyuk")
    public suspend fun sourceDetails(`value`: List<RuleSourceSourceDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDetails = mapped
    }

    /**
     * @param argument Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("hksvftgugpmluitt")
    public suspend
    fun sourceDetails(argument: List<suspend RuleSourceSourceDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleSourceSourceDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceDetails = mapped
    }

    /**
     * @param argument Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("mvqamuqoxxqkrwdk")
    public suspend fun sourceDetails(
        vararg
        argument: suspend RuleSourceSourceDetailArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleSourceSourceDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceDetails = mapped
    }

    /**
     * @param argument Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("oxyvpmbjlpscuwtx")
    public suspend fun sourceDetails(argument: suspend RuleSourceSourceDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleSourceSourceDetailArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceDetails = mapped
    }

    /**
     * @param values Provides the source and type of the event that causes AWS Config to evaluate your AWS resources. Only valid if `owner` is `CUSTOM_LAMBDA` or `CUSTOM_POLICY`. See Source Detail Below.
     */
    @JvmName("ettbupmyaistdyrk")
    public suspend fun sourceDetails(vararg values: RuleSourceSourceDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceDetails = mapped
    }

    /**
     * @param value For AWS Config managed rules, a predefined identifier, e.g `IAM_PASSWORD_POLICY`. For custom Lambda rules, the identifier is the ARN of the Lambda Function, such as `arn:aws:lambda:us-east-1:123456789012:function:custom_rule_name` or the `arn` attribute of the `aws.lambda.Function` resource.
     */
    @JvmName("mwetuonnemyldduh")
    public suspend fun sourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIdentifier = mapped
    }

    internal fun build(): RuleSourceArgs = RuleSourceArgs(
        customPolicyDetails = customPolicyDetails,
        owner = owner ?: throw PulumiNullFieldException("owner"),
        sourceDetails = sourceDetails,
        sourceIdentifier = sourceIdentifier,
    )
}
