@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.inputs

import com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableDebugLogDelivery The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
 * @property policyRuntime The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
 * @property policyText The policy definition containing the logic for your Config Custom Policy rule.
 */
public data class RuleSourceCustomPolicyDetailsArgs(
    public val enableDebugLogDelivery: Output<Boolean>? = null,
    public val policyRuntime: Output<String>,
    public val policyText: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs> {
    override fun toJava(): com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs =
        com.pulumi.aws.cfg.inputs.RuleSourceCustomPolicyDetailsArgs.builder()
            .enableDebugLogDelivery(enableDebugLogDelivery?.applyValue({ args0 -> args0 }))
            .policyRuntime(policyRuntime.applyValue({ args0 -> args0 }))
            .policyText(policyText.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleSourceCustomPolicyDetailsArgs].
 */
@PulumiTagMarker
public class RuleSourceCustomPolicyDetailsArgsBuilder internal constructor() {
    private var enableDebugLogDelivery: Output<Boolean>? = null

    private var policyRuntime: Output<String>? = null

    private var policyText: Output<String>? = null

    /**
     * @param value The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
     */
    @JvmName("grjmmiwscufsgsau")
    public suspend fun enableDebugLogDelivery(`value`: Output<Boolean>) {
        this.enableDebugLogDelivery = value
    }

    /**
     * @param value The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
     */
    @JvmName("tmexndebdcsyiddx")
    public suspend fun policyRuntime(`value`: Output<String>) {
        this.policyRuntime = value
    }

    /**
     * @param value The policy definition containing the logic for your Config Custom Policy rule.
     */
    @JvmName("rncdnyvpirtcetgm")
    public suspend fun policyText(`value`: Output<String>) {
        this.policyText = value
    }

    /**
     * @param value The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
     */
    @JvmName("giwgxoqbigagjasy")
    public suspend fun enableDebugLogDelivery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDebugLogDelivery = mapped
    }

    /**
     * @param value The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
     */
    @JvmName("xdgpjleslmbjujla")
    public suspend fun policyRuntime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyRuntime = mapped
    }

    /**
     * @param value The policy definition containing the logic for your Config Custom Policy rule.
     */
    @JvmName("mjyyipwqtyniygos")
    public suspend fun policyText(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyText = mapped
    }

    internal fun build(): RuleSourceCustomPolicyDetailsArgs = RuleSourceCustomPolicyDetailsArgs(
        enableDebugLogDelivery = enableDebugLogDelivery,
        policyRuntime = policyRuntime ?: throw PulumiNullFieldException("policyRuntime"),
        policyText = policyText ?: throw PulumiNullFieldException("policyText"),
    )
}
