@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountIds List of 12-digit account IDs of the account(s) being aggregated.
 * @property allRegions If true, aggregate existing AWS Config regions and future regions.
 * @property regions List of source regions being aggregated.
 * Either `regions` or `all_regions` (as true) must be specified.
 */
public data class ConfigurationAggregatorAccountAggregationSource(
    public val accountIds: List<String>,
    public val allRegions: Boolean? = null,
    public val regions: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.ConfigurationAggregatorAccountAggregationSource):
            ConfigurationAggregatorAccountAggregationSource =
            ConfigurationAggregatorAccountAggregationSource(
                accountIds = javaType.accountIds().map({ args0 -> args0 }),
                allRegions = javaType.allRegions().map({ args0 -> args0 }).orElse(null),
                regions = javaType.regions().map({ args0 -> args0 }),
            )
    }
}
