@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the attribute.
 * @property resourceValue Value is dynamic and changes at run-time.
 * @property staticValue Value is static and does not change at run-time.
 * @property staticValues List of static values.
 */
public data class RemediationConfigurationParameter(
    public val name: String,
    public val resourceValue: String? = null,
    public val staticValue: String? = null,
    public val staticValues: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RemediationConfigurationParameter):
            RemediationConfigurationParameter = RemediationConfigurationParameter(
            name = javaType.name(),
            resourceValue = javaType.resourceValue().map({ args0 -> args0 }).orElse(null),
            staticValue = javaType.staticValue().map({ args0 -> args0 }).orElse(null),
            staticValues = javaType.staticValues().map({ args0 -> args0 }),
        )
    }
}
