@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cfg.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableDebugLogDelivery The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is `false`.
 * @property policyRuntime The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://github.com/aws-cloudformation/cloudformation-guard).
 * @property policyText The policy definition containing the logic for your Config Custom Policy rule.
 */
public data class RuleSourceCustomPolicyDetails(
    public val enableDebugLogDelivery: Boolean? = null,
    public val policyRuntime: String,
    public val policyText: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cfg.outputs.RuleSourceCustomPolicyDetails):
            RuleSourceCustomPolicyDetails = RuleSourceCustomPolicyDetails(
            enableDebugLogDelivery = javaType.enableDebugLogDelivery().map({ args0 -> args0 }).orElse(null),
            policyRuntime = javaType.policyRuntime(),
            policyText = javaType.policyText(),
        )
    }
}
