@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceGlobalSettingsVoiceConnector
import com.pulumi.aws.chime.kotlin.outputs.SdkvoiceGlobalSettingsVoiceConnector.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SdkvoiceGlobalSettings].
 */
@PulumiTagMarker
public class SdkvoiceGlobalSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SdkvoiceGlobalSettingsArgs = SdkvoiceGlobalSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SdkvoiceGlobalSettingsArgsBuilder.() -> Unit) {
        val builder = SdkvoiceGlobalSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SdkvoiceGlobalSettings {
        val builtJavaResource = com.pulumi.aws.chime.SdkvoiceGlobalSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SdkvoiceGlobalSettings(builtJavaResource)
    }
}

/**
 * Resource for managing Amazon Chime SDK Voice Global Settings.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceGlobalSettings;
 * import com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceGlobalSettings("example", SdkvoiceGlobalSettingsArgs.builder()
 *             .voiceConnector(SdkvoiceGlobalSettingsVoiceConnectorArgs.builder()
 *                 .cdrBucket("example-bucket-name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Chime SDK Voice Global Settings using the `id` (AWS account ID). For example:
 * ```sh
 *  $ pulumi import aws:chime/sdkvoiceGlobalSettings:SdkvoiceGlobalSettings example 123456789012
 * ```
 *
 */
public class SdkvoiceGlobalSettings internal constructor(
    override val javaResource: com.pulumi.aws.chime.SdkvoiceGlobalSettings,
) : KotlinCustomResource(javaResource, SdkvoiceGlobalSettingsMapper) {
    /**
     * The Voice Connector settings. See voice_connector.
     */
    public val voiceConnector: Output<SdkvoiceGlobalSettingsVoiceConnector>
        get() = javaResource.voiceConnector().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object SdkvoiceGlobalSettingsMapper : ResourceMapper<SdkvoiceGlobalSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.SdkvoiceGlobalSettings::class == javaResource::class

    override fun map(javaResource: Resource): SdkvoiceGlobalSettings =
        SdkvoiceGlobalSettings(javaResource as com.pulumi.aws.chime.SdkvoiceGlobalSettings)
}

/**
 * @see [SdkvoiceGlobalSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SdkvoiceGlobalSettings].
 */
public suspend fun sdkvoiceGlobalSettings(
    name: String,
    block: suspend SdkvoiceGlobalSettingsResourceBuilder.() -> Unit,
): SdkvoiceGlobalSettings {
    val builder = SdkvoiceGlobalSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SdkvoiceGlobalSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sdkvoiceGlobalSettings(name: String): SdkvoiceGlobalSettings {
    val builder = SdkvoiceGlobalSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
