@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing Amazon Chime SDK Voice Global Settings.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceGlobalSettings;
 * import com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceGlobalSettingsVoiceConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceGlobalSettings("example", SdkvoiceGlobalSettingsArgs.builder()
 *             .voiceConnector(SdkvoiceGlobalSettingsVoiceConnectorArgs.builder()
 *                 .cdrBucket("example-bucket-name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Chime SDK Voice Global Settings using the `id` (AWS account ID). For example:
 * ```sh
 *  $ pulumi import aws:chime/sdkvoiceGlobalSettings:SdkvoiceGlobalSettings example 123456789012
 * ```
 * @property voiceConnector The Voice Connector settings. See voice_connector.
 */
public data class SdkvoiceGlobalSettingsArgs(
    public val voiceConnector: Output<SdkvoiceGlobalSettingsVoiceConnectorArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs> {
    override fun toJava(): com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs =
        com.pulumi.aws.chime.SdkvoiceGlobalSettingsArgs.builder()
            .voiceConnector(
                voiceConnector?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SdkvoiceGlobalSettingsArgs].
 */
@PulumiTagMarker
public class SdkvoiceGlobalSettingsArgsBuilder internal constructor() {
    private var voiceConnector: Output<SdkvoiceGlobalSettingsVoiceConnectorArgs>? = null

    /**
     * @param value The Voice Connector settings. See voice_connector.
     */
    @JvmName("mmhfaanxcipwghdk")
    public suspend fun voiceConnector(`value`: Output<SdkvoiceGlobalSettingsVoiceConnectorArgs>) {
        this.voiceConnector = value
    }

    /**
     * @param value The Voice Connector settings. See voice_connector.
     */
    @JvmName("esutevgbfgsyhwar")
    public suspend fun voiceConnector(`value`: SdkvoiceGlobalSettingsVoiceConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnector = mapped
    }

    /**
     * @param argument The Voice Connector settings. See voice_connector.
     */
    @JvmName("igpronhkltadlfnu")
    public suspend
    fun voiceConnector(argument: suspend SdkvoiceGlobalSettingsVoiceConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = SdkvoiceGlobalSettingsVoiceConnectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.voiceConnector = mapped
    }

    internal fun build(): SdkvoiceGlobalSettingsArgs = SdkvoiceGlobalSettingsArgs(
        voiceConnector = voiceConnector,
    )
}
