@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.SdkvoiceSipRuleArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceSipRuleTargetApplicationArgs
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceSipRuleTargetApplicationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A SIP rule associates your SIP media application with a phone number or a Request URI hostname. You can associate a SIP rule with more than one SIP media application. Each application then runs only that rule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.SdkvoiceSipRule;
 * import com.pulumi.aws.chime.SdkvoiceSipRuleArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceSipRuleTargetApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SdkvoiceSipRule("example", SdkvoiceSipRuleArgs.builder()
 *             .triggerType("RequestUriHostname")
 *             .triggerValue(aws_chime_voice_connector.example-voice-connector().outbound_host_name())
 *             .targetApplications(SdkvoiceSipRuleTargetApplicationArgs.builder()
 *                 .priority(1)
 *                 .sipMediaApplicationId(aws_chimesdkvoice_sip_media_application.example-sma().id())
 *                 .awsRegion("us-east-1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a ChimeSDKVoice SIP Rule using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/sdkvoiceSipRule:SdkvoiceSipRule example abcdef123456
 * ```
 * @property disabled Enables or disables a rule. You must disable rules before you can delete them.
 * @property name The name of the SIP rule.
 * @property targetApplications List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
 * @property triggerType The type of trigger assigned to the SIP rule in `trigger_value`. Valid values are `RequestUriHostname` or `ToPhoneNumber`.
 * @property triggerValue If `trigger_type` is `RequestUriHostname`, the value can be the outbound host name of an Amazon Chime Voice Connector. If `trigger_type` is `ToPhoneNumber`, the value can be a customer-owned phone number in the E164 format. The Sip Media Application specified in the Sip Rule is triggered if the request URI in an incoming SIP request matches the `RequestUriHostname`, or if the "To" header in the incoming SIP request matches the `ToPhoneNumber` value.
 * The following arguments are optional:
 */
public data class SdkvoiceSipRuleArgs(
    public val disabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val targetApplications: Output<List<SdkvoiceSipRuleTargetApplicationArgs>>? = null,
    public val triggerType: Output<String>? = null,
    public val triggerValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.SdkvoiceSipRuleArgs> {
    override fun toJava(): com.pulumi.aws.chime.SdkvoiceSipRuleArgs =
        com.pulumi.aws.chime.SdkvoiceSipRuleArgs.builder()
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .targetApplications(
                targetApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .triggerType(triggerType?.applyValue({ args0 -> args0 }))
            .triggerValue(triggerValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SdkvoiceSipRuleArgs].
 */
@PulumiTagMarker
public class SdkvoiceSipRuleArgsBuilder internal constructor() {
    private var disabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var targetApplications: Output<List<SdkvoiceSipRuleTargetApplicationArgs>>? = null

    private var triggerType: Output<String>? = null

    private var triggerValue: Output<String>? = null

    /**
     * @param value Enables or disables a rule. You must disable rules before you can delete them.
     */
    @JvmName("cpcgxnxrmfukmvxr")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The name of the SIP rule.
     */
    @JvmName("ehveymoctuhaprdd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("vhrmqylipqqemrxs")
    public suspend
    fun targetApplications(`value`: Output<List<SdkvoiceSipRuleTargetApplicationArgs>>) {
        this.targetApplications = value
    }

    @JvmName("pbboieynnuujxygr")
    public suspend fun targetApplications(
        vararg
        values: Output<SdkvoiceSipRuleTargetApplicationArgs>,
    ) {
        this.targetApplications = Output.all(values.asList())
    }

    /**
     * @param values List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("ptptdahgutisflwt")
    public suspend
    fun targetApplications(values: List<Output<SdkvoiceSipRuleTargetApplicationArgs>>) {
        this.targetApplications = Output.all(values)
    }

    /**
     * @param value The type of trigger assigned to the SIP rule in `trigger_value`. Valid values are `RequestUriHostname` or `ToPhoneNumber`.
     */
    @JvmName("dbowojyynbydruje")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value If `trigger_type` is `RequestUriHostname`, the value can be the outbound host name of an Amazon Chime Voice Connector. If `trigger_type` is `ToPhoneNumber`, the value can be a customer-owned phone number in the E164 format. The Sip Media Application specified in the Sip Rule is triggered if the request URI in an incoming SIP request matches the `RequestUriHostname`, or if the "To" header in the incoming SIP request matches the `ToPhoneNumber` value.
     * The following arguments are optional:
     */
    @JvmName("wirtijpruxcinkkg")
    public suspend fun triggerValue(`value`: Output<String>) {
        this.triggerValue = value
    }

    /**
     * @param value Enables or disables a rule. You must disable rules before you can delete them.
     */
    @JvmName("qontnqhdlmaebfph")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The name of the SIP rule.
     */
    @JvmName("qharslhisdnrugrj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("ohxxjqbwkumvklvc")
    public suspend fun targetApplications(`value`: List<SdkvoiceSipRuleTargetApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetApplications = mapped
    }

    /**
     * @param argument List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("dkmogbrlauqtpglq")
    public suspend
    fun targetApplications(argument: List<suspend SdkvoiceSipRuleTargetApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SdkvoiceSipRuleTargetApplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetApplications = mapped
    }

    /**
     * @param argument List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("eodawnuiuxnehtfh")
    public suspend fun targetApplications(
        vararg
        argument: suspend SdkvoiceSipRuleTargetApplicationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SdkvoiceSipRuleTargetApplicationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetApplications = mapped
    }

    /**
     * @param argument List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("qsvrfmjeivuqcgge")
    public suspend
    fun targetApplications(argument: suspend SdkvoiceSipRuleTargetApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SdkvoiceSipRuleTargetApplicationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetApplications = mapped
    }

    /**
     * @param values List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used. See `target_applications`.
     */
    @JvmName("mmvrjduttgiajwwu")
    public suspend fun targetApplications(vararg values: SdkvoiceSipRuleTargetApplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetApplications = mapped
    }

    /**
     * @param value The type of trigger assigned to the SIP rule in `trigger_value`. Valid values are `RequestUriHostname` or `ToPhoneNumber`.
     */
    @JvmName("yasoruwemdqymnnv")
    public suspend fun triggerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value If `trigger_type` is `RequestUriHostname`, the value can be the outbound host name of an Amazon Chime Voice Connector. If `trigger_type` is `ToPhoneNumber`, the value can be a customer-owned phone number in the E164 format. The Sip Media Application specified in the Sip Rule is triggered if the request URI in an incoming SIP request matches the `RequestUriHostname`, or if the "To" header in the incoming SIP request matches the `ToPhoneNumber` value.
     * The following arguments are optional:
     */
    @JvmName("biklonogauqqfkwa")
    public suspend fun triggerValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerValue = mapped
    }

    internal fun build(): SdkvoiceSipRuleArgs = SdkvoiceSipRuleArgs(
        disabled = disabled,
        name = name,
        targetApplications = targetApplications,
        triggerType = triggerType,
        triggerValue = triggerValue,
    )
}
