@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs
import com.pulumi.aws.chime.kotlin.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Chime SDK Voice Profile Domain.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomain;
 * import com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs;
 * import com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("KMS Key for Voice Profile Domain")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleSdkvoiceVoiceProfileDomain = new SdkvoiceVoiceProfileDomain("exampleSdkvoiceVoiceProfileDomain", SdkvoiceVoiceProfileDomainArgs.builder()
 *             .serverSideEncryptionConfiguration(SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs.builder()
 *                 .kmsKeyArn(exampleKey.arn())
 *                 .build())
 *             .description("My Voice Profile Domain")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Chime SDK Voice Profile Domain using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/sdkvoiceVoiceProfileDomain:SdkvoiceVoiceProfileDomain example abcdef123456
 * ```
 * @property description Description of Voice Profile Domain.
 * @property name Name of Voice Profile Domain.
 * @property serverSideEncryptionConfiguration Configuration for server side encryption.
 * @property tags
 */
public data class SdkvoiceVoiceProfileDomainArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serverSideEncryptionConfiguration:
    Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs> {
    override fun toJava(): com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs =
        com.pulumi.aws.chime.SdkvoiceVoiceProfileDomainArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionConfiguration(
                serverSideEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SdkvoiceVoiceProfileDomainArgs].
 */
@PulumiTagMarker
public class SdkvoiceVoiceProfileDomainArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var serverSideEncryptionConfiguration:
        Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of Voice Profile Domain.
     */
    @JvmName("houlaomhdkapemsq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of Voice Profile Domain.
     */
    @JvmName("blitrcokjnoccwgx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for server side encryption.
     */
    @JvmName("xxlalreyebdccsvg")
    public suspend
    fun serverSideEncryptionConfiguration(`value`: Output<SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs>) {
        this.serverSideEncryptionConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("khxkkykfndqxjurv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of Voice Profile Domain.
     */
    @JvmName("jvecuduqvepwdsyp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of Voice Profile Domain.
     */
    @JvmName("khnpoxksodqbsnsk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for server side encryption.
     */
    @JvmName("pspyyltguvkwjeyx")
    public suspend
    fun serverSideEncryptionConfiguration(`value`: SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration for server side encryption.
     */
    @JvmName("nutsfukhagbsyjpx")
    public suspend
    fun serverSideEncryptionConfiguration(argument: suspend SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("xwgoayknqyysejsj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("ktbsuqiniviskmsr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SdkvoiceVoiceProfileDomainArgs = SdkvoiceVoiceProfileDomainArgs(
        description = description,
        name = name,
        serverSideEncryptionConfiguration = serverSideEncryptionConfiguration,
        tags = tags,
    )
}
