@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VoiceConnector].
 */
@PulumiTagMarker
public class VoiceConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorArgs = VoiceConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnector {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnector(builtJavaResource)
    }
}

/**
 * Enables you to connect your phone system to the telephone network at a substantial cost savings by using SIP trunking.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VoiceConnector("test", VoiceConnectorArgs.builder()
 *             .awsRegion("us-east-1")
 *             .requireEncryption(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnector:VoiceConnector test example
 * ```
 *
 */
public class VoiceConnector internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnector,
) : KotlinCustomResource(javaResource, VoiceConnectorMapper) {
    /**
     * ARN (Amazon Resource Name) of the Amazon Chime Voice Connector.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
     */
    public val awsRegion: Output<String>
        get() = javaResource.awsRegion().applyValue({ args0 -> args0 })

    /**
     * The name of the Amazon Chime Voice Connector.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The outbound host name for the Amazon Chime Voice Connector.
     */
    public val outboundHostName: Output<String>
        get() = javaResource.outboundHostName().applyValue({ args0 -> args0 })

    /**
     * When enabled, requires encryption for the Amazon Chime Voice Connector.
     * The following arguments are optional:
     */
    public val requireEncryption: Output<Boolean>
        get() = javaResource.requireEncryption().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VoiceConnectorMapper : ResourceMapper<VoiceConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnector::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnector = VoiceConnector(
        javaResource as
            com.pulumi.aws.chime.VoiceConnector,
    )
}

/**
 * @see [VoiceConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnector].
 */
public suspend fun voiceConnector(
    name: String,
    block: suspend VoiceConnectorResourceBuilder.() -> Unit,
): VoiceConnector {
    val builder = VoiceConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnector(name: String): VoiceConnector {
    val builder = VoiceConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
