@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Enables you to connect your phone system to the telephone network at a substantial cost savings by using SIP trunking.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new VoiceConnector("test", VoiceConnectorArgs.builder()
 *             .awsRegion("us-east-1")
 *             .requireEncryption(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnector:VoiceConnector test example
 * ```
 * @property awsRegion The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
 * @property name The name of the Amazon Chime Voice Connector.
 * @property requireEncryption When enabled, requires encryption for the Amazon Chime Voice Connector.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VoiceConnectorArgs(
    public val awsRegion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val requireEncryption: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorArgs =
        com.pulumi.aws.chime.VoiceConnectorArgs.builder()
            .awsRegion(awsRegion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requireEncryption(requireEncryption?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VoiceConnectorArgs].
 */
@PulumiTagMarker
public class VoiceConnectorArgsBuilder internal constructor() {
    private var awsRegion: Output<String>? = null

    private var name: Output<String>? = null

    private var requireEncryption: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
     */
    @JvmName("mldodweosqmuxajo")
    public suspend fun awsRegion(`value`: Output<String>) {
        this.awsRegion = value
    }

    /**
     * @param value The name of the Amazon Chime Voice Connector.
     */
    @JvmName("hjpjdkkjhwljwsus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value When enabled, requires encryption for the Amazon Chime Voice Connector.
     * The following arguments are optional:
     */
    @JvmName("sykqaecotpfaiiuu")
    public suspend fun requireEncryption(`value`: Output<Boolean>) {
        this.requireEncryption = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("srvchbdglfxnenti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS Region in which the Amazon Chime Voice Connector is created. Default value: `us-east-1`
     */
    @JvmName("xpuapmuhtsjmvldx")
    public suspend fun awsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsRegion = mapped
    }

    /**
     * @param value The name of the Amazon Chime Voice Connector.
     */
    @JvmName("okulyhujrfjanuym")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value When enabled, requires encryption for the Amazon Chime Voice Connector.
     * The following arguments are optional:
     */
    @JvmName("gekmguldvtxnqgoh")
    public suspend fun requireEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireEncryption = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jhyclhxamfctoqun")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sktqdqkydvlcbomg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VoiceConnectorArgs = VoiceConnectorArgs(
        awsRegion = awsRegion,
        name = name,
        requireEncryption = requireEncryption,
        tags = tags,
    )
}
