@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorGroupConnector
import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorGroupConnector.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VoiceConnectorGroup].
 */
@PulumiTagMarker
public class VoiceConnectorGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorGroupArgs = VoiceConnectorGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorGroupArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnectorGroup {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnectorGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnectorGroup(builtJavaResource)
    }
}

/**
 * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including VoiceConnectorItems in the request.
 * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorGroup;
 * import com.pulumi.aws.chime.VoiceConnectorGroupArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vc1 = new VoiceConnector("vc1", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .awsRegion("us-east-1")
 *             .build());
 *         var vc2 = new VoiceConnector("vc2", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .awsRegion("us-west-2")
 *             .build());
 *         var group = new VoiceConnectorGroup("group", VoiceConnectorGroupArgs.builder()
 *             .connectors(
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc1.id())
 *                     .priority(1)
 *                     .build(),
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc2.id())
 *                     .priority(3)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorGroup:VoiceConnectorGroup default example
 * ```
 *
 */
public class VoiceConnectorGroup internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorGroup,
) : KotlinCustomResource(javaResource, VoiceConnectorGroupMapper) {
    /**
     * The Amazon Chime Voice Connectors to route inbound calls to.
     */
    public val connectors: Output<List<VoiceConnectorGroupConnector>>?
        get() = javaResource.connectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the Amazon Chime Voice Connector group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object VoiceConnectorGroupMapper : ResourceMapper<VoiceConnectorGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorGroup::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorGroup = VoiceConnectorGroup(
        javaResource
            as com.pulumi.aws.chime.VoiceConnectorGroup,
    )
}

/**
 * @see [VoiceConnectorGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorGroup].
 */
public suspend fun voiceConnectorGroup(
    name: String,
    block: suspend VoiceConnectorGroupResourceBuilder.() -> Unit,
): VoiceConnectorGroup {
    val builder = VoiceConnectorGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorGroup(name: String): VoiceConnectorGroup {
    val builder = VoiceConnectorGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
