@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorGroupArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorGroupConnectorArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorGroupConnectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including VoiceConnectorItems in the request.
 * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorGroup;
 * import com.pulumi.aws.chime.VoiceConnectorGroupArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vc1 = new VoiceConnector("vc1", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .awsRegion("us-east-1")
 *             .build());
 *         var vc2 = new VoiceConnector("vc2", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .awsRegion("us-west-2")
 *             .build());
 *         var group = new VoiceConnectorGroup("group", VoiceConnectorGroupArgs.builder()
 *             .connectors(
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc1.id())
 *                     .priority(1)
 *                     .build(),
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc2.id())
 *                     .priority(3)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorGroup:VoiceConnectorGroup default example
 * ```
 * @property connectors The Amazon Chime Voice Connectors to route inbound calls to.
 * @property name The name of the Amazon Chime Voice Connector group.
 */
public data class VoiceConnectorGroupArgs(
    public val connectors: Output<List<VoiceConnectorGroupConnectorArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorGroupArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorGroupArgs =
        com.pulumi.aws.chime.VoiceConnectorGroupArgs.builder()
            .connectors(
                connectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorGroupArgs].
 */
@PulumiTagMarker
public class VoiceConnectorGroupArgsBuilder internal constructor() {
    private var connectors: Output<List<VoiceConnectorGroupConnectorArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("rwancmhbhbkbenna")
    public suspend fun connectors(`value`: Output<List<VoiceConnectorGroupConnectorArgs>>) {
        this.connectors = value
    }

    @JvmName("mttauttpsaajjciw")
    public suspend fun connectors(vararg values: Output<VoiceConnectorGroupConnectorArgs>) {
        this.connectors = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("bntdebrkwdkokmob")
    public suspend fun connectors(values: List<Output<VoiceConnectorGroupConnectorArgs>>) {
        this.connectors = Output.all(values)
    }

    /**
     * @param value The name of the Amazon Chime Voice Connector group.
     */
    @JvmName("cywrbqlmmsxoooen")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("hmtdilugasofoiqu")
    public suspend fun connectors(`value`: List<VoiceConnectorGroupConnectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectors = mapped
    }

    /**
     * @param argument The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("yjpfxvghhreygqqf")
    public suspend
    fun connectors(argument: List<suspend VoiceConnectorGroupConnectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorGroupConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectors = mapped
    }

    /**
     * @param argument The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("nguplpxpfhctinlh")
    public suspend fun connectors(
        vararg
        argument: suspend VoiceConnectorGroupConnectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorGroupConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectors = mapped
    }

    /**
     * @param argument The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("xfylfnmeoeivhpke")
    public suspend
    fun connectors(argument: suspend VoiceConnectorGroupConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VoiceConnectorGroupConnectorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.connectors = mapped
    }

    /**
     * @param values The Amazon Chime Voice Connectors to route inbound calls to.
     */
    @JvmName("hxtoycfpmokdhsqd")
    public suspend fun connectors(vararg values: VoiceConnectorGroupConnectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectors = mapped
    }

    /**
     * @param value The name of the Amazon Chime Voice Connector group.
     */
    @JvmName("yqemkucyacjatjdj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VoiceConnectorGroupArgs = VoiceConnectorGroupArgs(
        connectors = connectors,
        name = name,
    )
}
