@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VoiceConnectorLogging].
 */
@PulumiTagMarker
public class VoiceConnectorLoggingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorLoggingArgs = VoiceConnectorLoggingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorLoggingArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorLoggingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnectorLogging {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnectorLogging(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnectorLogging(builtJavaResource)
    }
}

/**
 * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorLogging;
 * import com.pulumi.aws.chime.VoiceConnectorLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorLogging = new VoiceConnectorLogging("defaultVoiceConnectorLogging", VoiceConnectorLoggingArgs.builder()
 *             .enableSipLogs(true)
 *             .enableMediaMetricLogs(true)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Logging using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorLogging:VoiceConnectorLogging default abcdef1ghij2klmno3pqr4
 * ```
 *
 */
public class VoiceConnectorLogging internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorLogging,
) : KotlinCustomResource(javaResource, VoiceConnectorLoggingMapper) {
    /**
     * When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     */
    public val enableMediaMetricLogs: Output<Boolean>?
        get() = javaResource.enableMediaMetricLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    public val enableSipLogs: Output<Boolean>?
        get() = javaResource.enableSipLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: Output<String>
        get() = javaResource.voiceConnectorId().applyValue({ args0 -> args0 })
}

public object VoiceConnectorLoggingMapper : ResourceMapper<VoiceConnectorLogging> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorLogging::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorLogging =
        VoiceConnectorLogging(javaResource as com.pulumi.aws.chime.VoiceConnectorLogging)
}

/**
 * @see [VoiceConnectorLogging].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorLogging].
 */
public suspend fun voiceConnectorLogging(
    name: String,
    block: suspend VoiceConnectorLoggingResourceBuilder.() -> Unit,
): VoiceConnectorLogging {
    val builder = VoiceConnectorLoggingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorLogging].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorLogging(name: String): VoiceConnectorLogging {
    val builder = VoiceConnectorLoggingResourceBuilder()
    builder.name(name)
    return builder.build()
}
