@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorLogging;
 * import com.pulumi.aws.chime.VoiceConnectorLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorLogging = new VoiceConnectorLogging("defaultVoiceConnectorLogging", VoiceConnectorLoggingArgs.builder()
 *             .enableSipLogs(true)
 *             .enableMediaMetricLogs(true)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Logging using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorLogging:VoiceConnectorLogging default abcdef1ghij2klmno3pqr4
 * ```
 * @property enableMediaMetricLogs When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
 * @property enableSipLogs When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorLoggingArgs(
    public val enableMediaMetricLogs: Output<Boolean>? = null,
    public val enableSipLogs: Output<Boolean>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorLoggingArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorLoggingArgs =
        com.pulumi.aws.chime.VoiceConnectorLoggingArgs.builder()
            .enableMediaMetricLogs(enableMediaMetricLogs?.applyValue({ args0 -> args0 }))
            .enableSipLogs(enableSipLogs?.applyValue({ args0 -> args0 }))
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorLoggingArgs].
 */
@PulumiTagMarker
public class VoiceConnectorLoggingArgsBuilder internal constructor() {
    private var enableMediaMetricLogs: Output<Boolean>? = null

    private var enableSipLogs: Output<Boolean>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     */
    @JvmName("hygcpefcwqjdxclx")
    public suspend fun enableMediaMetricLogs(`value`: Output<Boolean>) {
        this.enableMediaMetricLogs = value
    }

    /**
     * @param value When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    @JvmName("yoqqppgyaayiosdu")
    public suspend fun enableSipLogs(`value`: Output<Boolean>) {
        this.enableSipLogs = value
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("jghofynrwpmqirgm")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     */
    @JvmName("odkpkrswmvfevjja")
    public suspend fun enableMediaMetricLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMediaMetricLogs = mapped
    }

    /**
     * @param value When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     */
    @JvmName("sdjhwftxblcupefj")
    public suspend fun enableSipLogs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSipLogs = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("nmhvbtlwipttmpdx")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorLoggingArgs = VoiceConnectorLoggingArgs(
        enableMediaMetricLogs = enableMediaMetricLogs,
        enableSipLogs = enableSipLogs,
        voiceConnectorId = voiceConnectorId,
    )
}
