@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorOrganizationRoute
import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorOrganizationRoute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VoiceConnectorOrganization].
 */
@PulumiTagMarker
public class VoiceConnectorOrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorOrganizationArgs = VoiceConnectorOrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorOrganizationArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorOrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnectorOrganization {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnectorOrganization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnectorOrganization(builtJavaResource)
    }
}

/**
 * Enable origination settings to control inbound calling to your SIP infrastructure.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorOrganization;
 * import com.pulumi.aws.chime.VoiceConnectorOrganizationArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorOrganization = new VoiceConnectorOrganization("defaultVoiceConnectorOrganization", VoiceConnectorOrganizationArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .routes(
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host("127.0.0.1")
 *                     .port(8081)
 *                     .protocol("TCP")
 *                     .priority(1)
 *                     .weight(1)
 *                     .build(),
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host("127.0.0.2")
 *                     .port(8082)
 *                     .protocol("TCP")
 *                     .priority(2)
 *                     .weight(10)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Origination using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization default abcdef1ghij2klmno3pqr4
 * ```
 *
 */
public class VoiceConnectorOrganization internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorOrganization,
) : KotlinCustomResource(javaResource, VoiceConnectorOrganizationMapper) {
    /**
     * When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    public val routes: Output<List<VoiceConnectorOrganizationRoute>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: Output<String>
        get() = javaResource.voiceConnectorId().applyValue({ args0 -> args0 })
}

public object VoiceConnectorOrganizationMapper : ResourceMapper<VoiceConnectorOrganization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorOrganization::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorOrganization =
        VoiceConnectorOrganization(javaResource as com.pulumi.aws.chime.VoiceConnectorOrganization)
}

/**
 * @see [VoiceConnectorOrganization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorOrganization].
 */
public suspend fun voiceConnectorOrganization(
    name: String,
    block: suspend VoiceConnectorOrganizationResourceBuilder.() -> Unit,
):
    VoiceConnectorOrganization {
    val builder = VoiceConnectorOrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorOrganization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorOrganization(name: String): VoiceConnectorOrganization {
    val builder = VoiceConnectorOrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
