@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorOrganizationArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorOrganizationRouteArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorOrganizationRouteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Enable origination settings to control inbound calling to your SIP infrastructure.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorOrganization;
 * import com.pulumi.aws.chime.VoiceConnectorOrganizationArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorOrganization = new VoiceConnectorOrganization("defaultVoiceConnectorOrganization", VoiceConnectorOrganizationArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .routes(
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host("127.0.0.1")
 *                     .port(8081)
 *                     .protocol("TCP")
 *                     .priority(1)
 *                     .weight(1)
 *                     .build(),
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host("127.0.0.2")
 *                     .port(8082)
 *                     .protocol("TCP")
 *                     .priority(2)
 *                     .weight(10)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Origination using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization default abcdef1ghij2klmno3pqr4
 * ```
 * @property disabled When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
 * @property routes Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorOrganizationArgs(
    public val disabled: Output<Boolean>? = null,
    public val routes: Output<List<VoiceConnectorOrganizationRouteArgs>>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorOrganizationArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorOrganizationArgs =
        com.pulumi.aws.chime.VoiceConnectorOrganizationArgs.builder()
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorOrganizationArgs].
 */
@PulumiTagMarker
public class VoiceConnectorOrganizationArgsBuilder internal constructor() {
    private var disabled: Output<Boolean>? = null

    private var routes: Output<List<VoiceConnectorOrganizationRouteArgs>>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
     */
    @JvmName("dbqmukkojmkbpqsu")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("gyocwqdqubcvngqp")
    public suspend fun routes(`value`: Output<List<VoiceConnectorOrganizationRouteArgs>>) {
        this.routes = value
    }

    @JvmName("onininyuttdanbpe")
    public suspend fun routes(vararg values: Output<VoiceConnectorOrganizationRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("iinopngxpavxgaov")
    public suspend fun routes(values: List<Output<VoiceConnectorOrganizationRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("haifkacgccykxlil")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
     */
    @JvmName("ofmnmcttbpdwbfgj")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("hywesrhpqyuenddq")
    public suspend fun routes(`value`: List<VoiceConnectorOrganizationRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("yovyayxoldivvhrm")
    public suspend
    fun routes(argument: List<suspend VoiceConnectorOrganizationRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorOrganizationRouteArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("dwcfphkrvpagdnnm")
    public suspend fun routes(
        vararg
        argument: suspend VoiceConnectorOrganizationRouteArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorOrganizationRouteArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("ikcobrhsallnuarr")
    public suspend
    fun routes(argument: suspend VoiceConnectorOrganizationRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VoiceConnectorOrganizationRouteArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     */
    @JvmName("uhkpfplfonwudubc")
    public suspend fun routes(vararg values: VoiceConnectorOrganizationRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("blxcqrcdbsraqtyx")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorOrganizationArgs = VoiceConnectorOrganizationArgs(
        disabled = disabled,
        routes = routes,
        voiceConnectorId = voiceConnectorId,
    )
}
