@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorStreamingMediaInsightsConfiguration
import com.pulumi.aws.chime.kotlin.outputs.VoiceConnectorStreamingMediaInsightsConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VoiceConnectorStreaming].
 */
@PulumiTagMarker
public class VoiceConnectorStreamingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorStreamingArgs = VoiceConnectorStreamingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorStreamingArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorStreamingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnectorStreaming {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnectorStreaming(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnectorStreaming(builtJavaResource)
    }
}

/**
 * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Amazon Kinesis.
 * It also sets the retention period, in hours, for the Amazon Kinesis data.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .build());
 *     }
 * }
 * ```
 * ### Example Usage With Media Insights
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("mediapipelines.chime.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(2)
 *             .build());
 *         var exampleMediaInsightsPipelineConfiguration = new MediaInsightsPipelineConfiguration("exampleMediaInsightsPipelineConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(exampleRole.arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(exampleStream.arn())
 *                         .build())
 *                     .build())
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .mediaInsightsConfiguration(VoiceConnectorStreamingMediaInsightsConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .configurationArn(exampleMediaInsightsPipelineConfiguration.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Streaming using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorStreaming:VoiceConnectorStreaming default abcdef1ghij2klmno3pqr4
 * ```
 *
 */
public class VoiceConnectorStreaming internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorStreaming,
) : KotlinCustomResource(javaResource, VoiceConnectorStreamingMapper) {
    /**
     * The retention period, in hours, for the Amazon Kinesis data.
     */
    public val dataRetention: Output<Int>
        get() = javaResource.dataRetention().applyValue({ args0 -> args0 })

    /**
     * When true, media streaming to Amazon Kinesis is turned off. Default: `false`
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The media insights configuration. See `media_insights_configuration`.
     */
    public val mediaInsightsConfiguration: Output<VoiceConnectorStreamingMediaInsightsConfiguration>?
        get() = javaResource.mediaInsightsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    public val streamingNotificationTargets: Output<List<String>>?
        get() = javaResource.streamingNotificationTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: Output<String>
        get() = javaResource.voiceConnectorId().applyValue({ args0 -> args0 })
}

public object VoiceConnectorStreamingMapper : ResourceMapper<VoiceConnectorStreaming> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorStreaming::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorStreaming =
        VoiceConnectorStreaming(javaResource as com.pulumi.aws.chime.VoiceConnectorStreaming)
}

/**
 * @see [VoiceConnectorStreaming].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorStreaming].
 */
public suspend fun voiceConnectorStreaming(
    name: String,
    block: suspend VoiceConnectorStreamingResourceBuilder.() -> Unit,
): VoiceConnectorStreaming {
    val builder = VoiceConnectorStreamingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorStreaming].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorStreaming(name: String): VoiceConnectorStreaming {
    val builder = VoiceConnectorStreamingResourceBuilder()
    builder.name(name)
    return builder.build()
}
