@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorStreamingArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Amazon Kinesis.
 * It also sets the retention period, in hours, for the Amazon Kinesis data.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .build());
 *     }
 * }
 * ```
 * ### Example Usage With Media Insights
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorStreaming;
 * import com.pulumi.aws.chime.VoiceConnectorStreamingArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("mediapipelines.chime.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(2)
 *             .build());
 *         var exampleMediaInsightsPipelineConfiguration = new MediaInsightsPipelineConfiguration("exampleMediaInsightsPipelineConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(exampleRole.arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(exampleStream.arn())
 *                         .build())
 *                     .build())
 *             .build());
 *         var defaultVoiceConnectorStreaming = new VoiceConnectorStreaming("defaultVoiceConnectorStreaming", VoiceConnectorStreamingArgs.builder()
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .dataRetention(7)
 *             .streamingNotificationTargets("SQS")
 *             .mediaInsightsConfiguration(VoiceConnectorStreamingMediaInsightsConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .configurationArn(exampleMediaInsightsPipelineConfiguration.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Streaming using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorStreaming:VoiceConnectorStreaming default abcdef1ghij2klmno3pqr4
 * ```
 * @property dataRetention The retention period, in hours, for the Amazon Kinesis data.
 * @property disabled When true, media streaming to Amazon Kinesis is turned off. Default: `false`
 * @property mediaInsightsConfiguration The media insights configuration. See `media_insights_configuration`.
 * @property streamingNotificationTargets The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorStreamingArgs(
    public val dataRetention: Output<Int>? = null,
    public val disabled: Output<Boolean>? = null,
    public val mediaInsightsConfiguration:
    Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>? = null,
    public val streamingNotificationTargets: Output<List<String>>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorStreamingArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorStreamingArgs =
        com.pulumi.aws.chime.VoiceConnectorStreamingArgs.builder()
            .dataRetention(dataRetention?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .mediaInsightsConfiguration(
                mediaInsightsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .streamingNotificationTargets(
                streamingNotificationTargets?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorStreamingArgs].
 */
@PulumiTagMarker
public class VoiceConnectorStreamingArgsBuilder internal constructor() {
    private var dataRetention: Output<Int>? = null

    private var disabled: Output<Boolean>? = null

    private var mediaInsightsConfiguration:
        Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>? = null

    private var streamingNotificationTargets: Output<List<String>>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value The retention period, in hours, for the Amazon Kinesis data.
     */
    @JvmName("bbjmadolkbdsdtim")
    public suspend fun dataRetention(`value`: Output<Int>) {
        this.dataRetention = value
    }

    /**
     * @param value When true, media streaming to Amazon Kinesis is turned off. Default: `false`
     */
    @JvmName("gopavmdaddxrhlvi")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("axtesggypmglxqde")
    public suspend
    fun mediaInsightsConfiguration(`value`: Output<VoiceConnectorStreamingMediaInsightsConfigurationArgs>) {
        this.mediaInsightsConfiguration = value
    }

    /**
     * @param value The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("wjcgnjeuqctdcrgd")
    public suspend fun streamingNotificationTargets(`value`: Output<List<String>>) {
        this.streamingNotificationTargets = value
    }

    @JvmName("gtqnhrklcpggivqh")
    public suspend fun streamingNotificationTargets(vararg values: Output<String>) {
        this.streamingNotificationTargets = Output.all(values.asList())
    }

    /**
     * @param values The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("smhwvgksidvqxssi")
    public suspend fun streamingNotificationTargets(values: List<Output<String>>) {
        this.streamingNotificationTargets = Output.all(values)
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("aalwdhopgxbaggcf")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value The retention period, in hours, for the Amazon Kinesis data.
     */
    @JvmName("oneltrcjrjwjgctj")
    public suspend fun dataRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRetention = mapped
    }

    /**
     * @param value When true, media streaming to Amazon Kinesis is turned off. Default: `false`
     */
    @JvmName("ogfxxbobqxdmxeni")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("sarfvvdnpwjeguod")
    public suspend
    fun mediaInsightsConfiguration(`value`: VoiceConnectorStreamingMediaInsightsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaInsightsConfiguration = mapped
    }

    /**
     * @param argument The media insights configuration. See `media_insights_configuration`.
     */
    @JvmName("ikmkuujmsojqbtke")
    public suspend
    fun mediaInsightsConfiguration(argument: suspend VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mediaInsightsConfiguration = mapped
    }

    /**
     * @param value The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("rachiqfblkttrtca")
    public suspend fun streamingNotificationTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingNotificationTargets = mapped
    }

    /**
     * @param values The streaming notification targets. Valid Values: `EventBridge | SNS | SQS`
     */
    @JvmName("jthuxforewxjltkq")
    public suspend fun streamingNotificationTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamingNotificationTargets = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("vevjaxmgpsrxncyw")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorStreamingArgs = VoiceConnectorStreamingArgs(
        dataRetention = dataRetention,
        disabled = disabled,
        mediaInsightsConfiguration = mediaInsightsConfiguration,
        streamingNotificationTargets = streamingNotificationTargets,
        voiceConnectorId = voiceConnectorId,
    )
}
