@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VoiceConnectorTermination].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VoiceConnectorTerminationArgs = VoiceConnectorTerminationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VoiceConnectorTerminationArgsBuilder.() -> Unit) {
        val builder = VoiceConnectorTerminationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VoiceConnectorTermination {
        val builtJavaResource = com.pulumi.aws.chime.VoiceConnectorTermination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VoiceConnectorTermination(builtJavaResource)
    }
}

/**
 * Enable Termination settings to control outbound calling from your SIP infrastructure.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(false)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorTermination:VoiceConnectorTermination default abcdef1ghij2klmno3pqr4
 * ```
 *
 */
public class VoiceConnectorTermination internal constructor(
    override val javaResource: com.pulumi.aws.chime.VoiceConnectorTermination,
) : KotlinCustomResource(javaResource, VoiceConnectorTerminationMapper) {
    /**
     * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    public val callingRegions: Output<List<String>>
        get() = javaResource.callingRegions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The IP addresses allowed to make calls, in CIDR format.
     */
    public val cidrAllowLists: Output<List<String>>
        get() = javaResource.cidrAllowLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The limit on calls per second. Max value based on account service quota. Default value of `1`.
     */
    public val cpsLimit: Output<Int>?
        get() = javaResource.cpsLimit().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The default caller ID phone number.
     */
    public val defaultPhoneNumber: Output<String>?
        get() = javaResource.defaultPhoneNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When termination settings are disabled, outbound calls can not be made.
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: Output<String>
        get() = javaResource.voiceConnectorId().applyValue({ args0 -> args0 })
}

public object VoiceConnectorTerminationMapper : ResourceMapper<VoiceConnectorTermination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chime.VoiceConnectorTermination::class == javaResource::class

    override fun map(javaResource: Resource): VoiceConnectorTermination =
        VoiceConnectorTermination(javaResource as com.pulumi.aws.chime.VoiceConnectorTermination)
}

/**
 * @see [VoiceConnectorTermination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VoiceConnectorTermination].
 */
public suspend fun voiceConnectorTermination(
    name: String,
    block: suspend VoiceConnectorTerminationResourceBuilder.() -> Unit,
): VoiceConnectorTermination {
    val builder = VoiceConnectorTerminationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VoiceConnectorTermination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun voiceConnectorTermination(name: String): VoiceConnectorTermination {
    val builder = VoiceConnectorTerminationResourceBuilder()
    builder.name(name)
    return builder.build()
}
