@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorTerminationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Enable Termination settings to control outbound calling from your SIP infrastructure.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(false)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorTermination:VoiceConnectorTermination default abcdef1ghij2klmno3pqr4
 * ```
 * @property callingRegions The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
 * @property cidrAllowLists The IP addresses allowed to make calls, in CIDR format.
 * @property cpsLimit The limit on calls per second. Max value based on account service quota. Default value of `1`.
 * @property defaultPhoneNumber The default caller ID phone number.
 * @property disabled When termination settings are disabled, outbound calls can not be made.
 * @property voiceConnectorId The Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorTerminationArgs(
    public val callingRegions: Output<List<String>>? = null,
    public val cidrAllowLists: Output<List<String>>? = null,
    public val cpsLimit: Output<Int>? = null,
    public val defaultPhoneNumber: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorTerminationArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorTerminationArgs =
        com.pulumi.aws.chime.VoiceConnectorTerminationArgs.builder()
            .callingRegions(callingRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cidrAllowLists(cidrAllowLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpsLimit(cpsLimit?.applyValue({ args0 -> args0 }))
            .defaultPhoneNumber(defaultPhoneNumber?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorTerminationArgs].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationArgsBuilder internal constructor() {
    private var callingRegions: Output<List<String>>? = null

    private var cidrAllowLists: Output<List<String>>? = null

    private var cpsLimit: Output<Int>? = null

    private var defaultPhoneNumber: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("snabswgkoiqphppj")
    public suspend fun callingRegions(`value`: Output<List<String>>) {
        this.callingRegions = value
    }

    @JvmName("tibadwwlycnbpctq")
    public suspend fun callingRegions(vararg values: Output<String>) {
        this.callingRegions = Output.all(values.asList())
    }

    /**
     * @param values The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("pncbdtjsscqxivvr")
    public suspend fun callingRegions(values: List<Output<String>>) {
        this.callingRegions = Output.all(values)
    }

    /**
     * @param value The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("rlbunafyfahxxujg")
    public suspend fun cidrAllowLists(`value`: Output<List<String>>) {
        this.cidrAllowLists = value
    }

    @JvmName("saibggqgkxlebmrn")
    public suspend fun cidrAllowLists(vararg values: Output<String>) {
        this.cidrAllowLists = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("bowktfjoohnwmvlk")
    public suspend fun cidrAllowLists(values: List<Output<String>>) {
        this.cidrAllowLists = Output.all(values)
    }

    /**
     * @param value The limit on calls per second. Max value based on account service quota. Default value of `1`.
     */
    @JvmName("tcnjyixlqqaiiemh")
    public suspend fun cpsLimit(`value`: Output<Int>) {
        this.cpsLimit = value
    }

    /**
     * @param value The default caller ID phone number.
     */
    @JvmName("pwgvuibcrovvdebc")
    public suspend fun defaultPhoneNumber(`value`: Output<String>) {
        this.defaultPhoneNumber = value
    }

    /**
     * @param value When termination settings are disabled, outbound calls can not be made.
     */
    @JvmName("xcxrwmitawkxouxg")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("dgruilayjfwdjlnh")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("akciyqyixkdbwwek")
    public suspend fun callingRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callingRegions = mapped
    }

    /**
     * @param values The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    @JvmName("yfvdlcmvfiuqdpbc")
    public suspend fun callingRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.callingRegions = mapped
    }

    /**
     * @param value The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("wgqxewwrlgkmukxm")
    public suspend fun cidrAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrAllowLists = mapped
    }

    /**
     * @param values The IP addresses allowed to make calls, in CIDR format.
     */
    @JvmName("bnukoqxyfoujyhfj")
    public suspend fun cidrAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrAllowLists = mapped
    }

    /**
     * @param value The limit on calls per second. Max value based on account service quota. Default value of `1`.
     */
    @JvmName("lahwxcdrhcoosnkf")
    public suspend fun cpsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpsLimit = mapped
    }

    /**
     * @param value The default caller ID phone number.
     */
    @JvmName("aoutetownkrgeeun")
    public suspend fun defaultPhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPhoneNumber = mapped
    }

    /**
     * @param value When termination settings are disabled, outbound calls can not be made.
     */
    @JvmName("xtldnywhyksgkceg")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value The Amazon Chime Voice Connector ID.
     */
    @JvmName("xfvfkvhlyeoqpbmb")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorTerminationArgs = VoiceConnectorTerminationArgs(
        callingRegions = callingRegions,
        cidrAllowLists = cidrAllowLists,
        cpsLimit = cpsLimit,
        defaultPhoneNumber = defaultPhoneNumber,
        disabled = disabled,
        voiceConnectorId = voiceConnectorId,
    )
}
