@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin

import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs.builder
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorTerminationCredentialsCredentialArgs
import com.pulumi.aws.chime.kotlin.inputs.VoiceConnectorTerminationCredentialsCredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
 * > **Note:** Voice Connector Termination Credentials requires a Voice Connector Termination to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentials;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector("defaultVoiceConnector", VoiceConnectorArgs.builder()
 *             .requireEncryption(true)
 *             .build());
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination("defaultVoiceConnectorTermination", VoiceConnectorTerminationArgs.builder()
 *             .disabled(true)
 *             .cpsLimit(1)
 *             .cidrAllowLists("50.35.78.96/31")
 *             .callingRegions(
 *                 "US",
 *                 "CA")
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 *         var defaultVoiceConnectorTerminationCredentials = new VoiceConnectorTerminationCredentials("defaultVoiceConnectorTerminationCredentials", VoiceConnectorTerminationCredentialsArgs.builder()
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .credentials(VoiceConnectorTerminationCredentialsCredentialArgs.builder()
 *                 .username("test")
 *                 .password("test!")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultVoiceConnectorTermination)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime Voice Connector Termination Credentials using the `voice_connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials default abcdef1ghij2klmno3pqr4
 * ```
 * @property credentials List of termination SIP credentials.
 * @property voiceConnectorId Amazon Chime Voice Connector ID.
 */
public data class VoiceConnectorTerminationCredentialsArgs(
    public val credentials: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>? = null,
    public val voiceConnectorId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs =
        com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs.builder()
            .credentials(
                credentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .voiceConnectorId(voiceConnectorId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorTerminationCredentialsArgs].
 */
@PulumiTagMarker
public class VoiceConnectorTerminationCredentialsArgsBuilder internal constructor() {
    private var credentials: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>? = null

    private var voiceConnectorId: Output<String>? = null

    /**
     * @param value List of termination SIP credentials.
     */
    @JvmName("vtuqqrrdbibpwcxh")
    public suspend
    fun credentials(`value`: Output<List<VoiceConnectorTerminationCredentialsCredentialArgs>>) {
        this.credentials = value
    }

    @JvmName("tgoenesgryhuicsx")
    public suspend fun credentials(
        vararg
        values: Output<VoiceConnectorTerminationCredentialsCredentialArgs>,
    ) {
        this.credentials = Output.all(values.asList())
    }

    /**
     * @param values List of termination SIP credentials.
     */
    @JvmName("mkgrjftipuvjneeq")
    public suspend
    fun credentials(values: List<Output<VoiceConnectorTerminationCredentialsCredentialArgs>>) {
        this.credentials = Output.all(values)
    }

    /**
     * @param value Amazon Chime Voice Connector ID.
     */
    @JvmName("xmecoduwxqdmxtdh")
    public suspend fun voiceConnectorId(`value`: Output<String>) {
        this.voiceConnectorId = value
    }

    /**
     * @param value List of termination SIP credentials.
     */
    @JvmName("pganjwkfhyicjosk")
    public suspend
    fun credentials(`value`: List<VoiceConnectorTerminationCredentialsCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("gdwortmdrnsilknj")
    public suspend
    fun credentials(argument: List<suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("jshvfstcymuqvpyg")
    public suspend fun credentials(
        vararg
        argument: suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param argument List of termination SIP credentials.
     */
    @JvmName("ealchbmxgtplfqxc")
    public suspend
    fun credentials(argument: suspend VoiceConnectorTerminationCredentialsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VoiceConnectorTerminationCredentialsCredentialArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param values List of termination SIP credentials.
     */
    @JvmName("cooimojlwolepkxn")
    public suspend fun credentials(
        vararg
        values: VoiceConnectorTerminationCredentialsCredentialArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Amazon Chime Voice Connector ID.
     */
    @JvmName("vkplifwkoiyynxeb")
    public suspend fun voiceConnectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceConnectorId = mapped
    }

    internal fun build(): VoiceConnectorTerminationCredentialsArgs =
        VoiceConnectorTerminationCredentialsArgs(
            credentials = credentials,
            voiceConnectorId = voiceConnectorId,
        )
}
