@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lambdaArn Valid Amazon Resource Name (ARN) of the Lambda function, version, or alias. The function must be created in the same AWS Region as the SIP media application.
 */
public data class SdkvoiceSipMediaApplicationEndpointsArgs(
    public val lambdaArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs> {
    override fun toJava(): com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs =
        com.pulumi.aws.chime.inputs.SdkvoiceSipMediaApplicationEndpointsArgs.builder()
            .lambdaArn(lambdaArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SdkvoiceSipMediaApplicationEndpointsArgs].
 */
@PulumiTagMarker
public class SdkvoiceSipMediaApplicationEndpointsArgsBuilder internal constructor() {
    private var lambdaArn: Output<String>? = null

    /**
     * @param value Valid Amazon Resource Name (ARN) of the Lambda function, version, or alias. The function must be created in the same AWS Region as the SIP media application.
     */
    @JvmName("dqmsajplecqfrsvg")
    public suspend fun lambdaArn(`value`: Output<String>) {
        this.lambdaArn = value
    }

    /**
     * @param value Valid Amazon Resource Name (ARN) of the Lambda function, version, or alias. The function must be created in the same AWS Region as the SIP media application.
     */
    @JvmName("mbkvcprnokysuirn")
    public suspend fun lambdaArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambdaArn = mapped
    }

    internal fun build(): SdkvoiceSipMediaApplicationEndpointsArgs =
        SdkvoiceSipMediaApplicationEndpointsArgs(
            lambdaArn = lambdaArn ?: throw PulumiNullFieldException("lambdaArn"),
        )
}
