@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn ARN for KMS Key.
 * The following arguments are optional:
 */
public data class SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs(
    public val kmsKeyArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs =
        com.pulumi.aws.chime.inputs.SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs.builder()
            .kmsKeyArn(kmsKeyArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgsBuilder internal
constructor() {
    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value ARN for KMS Key.
     * The following arguments are optional:
     */
    @JvmName("njqbhxwehvphbgtj")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value ARN for KMS Key.
     * The following arguments are optional:
     */
    @JvmName("excphnpcvwdanbvk")
    public suspend fun kmsKeyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs =
        SdkvoiceVoiceProfileDomainServerSideEncryptionConfigurationArgs(
            kmsKeyArn = kmsKeyArn ?: throw PulumiNullFieldException("kmsKeyArn"),
        )
}
