@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.inputs

import com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationArn The media insights configuration that will be invoked by the Voice Connector.
 * @property disabled When `true`, the media insights configuration is not enabled. Defaults to `false`.
 */
public data class VoiceConnectorStreamingMediaInsightsConfigurationArgs(
    public val configurationArn: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs =
        com.pulumi.aws.chime.inputs.VoiceConnectorStreamingMediaInsightsConfigurationArgs.builder()
            .configurationArn(configurationArn?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VoiceConnectorStreamingMediaInsightsConfigurationArgs].
 */
@PulumiTagMarker
public class VoiceConnectorStreamingMediaInsightsConfigurationArgsBuilder internal constructor() {
    private var configurationArn: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    /**
     * @param value The media insights configuration that will be invoked by the Voice Connector.
     */
    @JvmName("bwkdhlraibbncgek")
    public suspend fun configurationArn(`value`: Output<String>) {
        this.configurationArn = value
    }

    /**
     * @param value When `true`, the media insights configuration is not enabled. Defaults to `false`.
     */
    @JvmName("enoclqbvajctkhob")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value The media insights configuration that will be invoked by the Voice Connector.
     */
    @JvmName("jkohevagjqxyaqbm")
    public suspend fun configurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationArn = mapped
    }

    /**
     * @param value When `true`, the media insights configuration is not enabled. Defaults to `false`.
     */
    @JvmName("vyjsfpfgrndlmsuq")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    internal fun build(): VoiceConnectorStreamingMediaInsightsConfigurationArgs =
        VoiceConnectorStreamingMediaInsightsConfigurationArgs(
            configurationArn = configurationArn,
            disabled = disabled,
        )
}
