@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property host The FQDN or IP address to contact for origination traffic.
 * @property port The designated origination route port. Defaults to `5060`.
 * @property priority The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
 * @property protocol The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
 * @property weight The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
 */
public data class VoiceConnectorOrganizationRoute(
    public val host: String,
    public val port: Int? = null,
    public val priority: Int,
    public val protocol: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.chime.outputs.VoiceConnectorOrganizationRoute):
            VoiceConnectorOrganizationRoute = VoiceConnectorOrganizationRoute(
            host = javaType.host(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            protocol = javaType.protocol(),
            weight = javaType.weight(),
        )
    }
}
