@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chime.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configurationArn The media insights configuration that will be invoked by the Voice Connector.
 * @property disabled When `true`, the media insights configuration is not enabled. Defaults to `false`.
 */
public data class VoiceConnectorStreamingMediaInsightsConfiguration(
    public val configurationArn: String? = null,
    public val disabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.chime.outputs.VoiceConnectorStreamingMediaInsightsConfiguration):
            VoiceConnectorStreamingMediaInsightsConfiguration =
            VoiceConnectorStreamingMediaInsightsConfiguration(
                configurationArn = javaType.configurationArn().map({ args0 -> args0 }).orElse(null),
                disabled = javaType.disabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
