@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin

import com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElement
import com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationRealTimeAlertConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElement.Companion.toKotlin as mediaInsightsPipelineConfigurationElementToKotlin
import com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationRealTimeAlertConfiguration.Companion.toKotlin as mediaInsightsPipelineConfigurationRealTimeAlertConfigurationToKotlin

/**
 * Builder for [MediaInsightsPipelineConfiguration].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MediaInsightsPipelineConfigurationArgs = MediaInsightsPipelineConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MediaInsightsPipelineConfigurationArgsBuilder.() -> Unit) {
        val builder = MediaInsightsPipelineConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MediaInsightsPipelineConfiguration {
        val builtJavaResource =
            com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MediaInsightsPipelineConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Chime SDK Media Pipelines Media Insights Pipeline Configuration.
 * Consult the [Call analytics developer guide](https://docs.aws.amazon.com/chime-sdk/latest/dg/call-analytics.html) for more detailed information about usage.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stream("example", StreamArgs.builder()
 *             .shardCount(2)
 *             .build());
 *         final var mediaPipelinesAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("mediapipelines.chime.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var callAnalyticsRole = new Role("callAnalyticsRole", RoleArgs.builder()
 *             .assumeRolePolicy(mediaPipelinesAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(callAnalyticsRole.arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(example.arn())
 *                         .build())
 *                     .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Key1", "Value1"),
 *                 Map.entry("Key2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Transcribe Call Analytics processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var transcribeAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transcribe.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var postCallRole = new Role("postCallRole", RoleArgs.builder()
 *             .assumeRolePolicy(transcribeAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .callAnalyticsStreamCategories(
 *                             "category_1",
 *                             "category_2")
 *                         .contentRedactionType("PII")
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode("en-US")
 *                         .languageModelName("MyLanguageModel")
 *                         .partialResultsStability("high")
 *                         .piiEntityTypes("ADDRESS,BANK_ACCOUNT_NUMBER")
 *                         .postCallAnalyticsSettings(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs.builder()
 *                             .contentRedactionOutput("redacted")
 *                             .dataAccessRoleArn(postCallRole.arn())
 *                             .outputEncryptionKmsKeyId("MyKmsKeyId")
 *                             .outputLocation("s3://MyBucket")
 *                             .build())
 *                         .vocabularyFilterMethod("mask")
 *                         .vocabularyFilterName("MyVocabularyFilter")
 *                         .vocabularyName("MyVocabulary")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Real time alerts usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.call_analytics_role().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .realTimeAlertConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .rules(
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("IssueDetection")
 *                         .issueDetectionConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs.builder()
 *                             .ruleName("MyIssueDetectionRule")
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("KeywordMatch")
 *                         .keywordMatchConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs.builder()
 *                             .keywords(
 *                                 "keyword1",
 *                                 "keyword2")
 *                             .negate(false)
 *                             .ruleName("MyKeywordMatchRule")
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("Sentiment")
 *                         .sentimentConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs.builder()
 *                             .ruleName("MySentimentRule")
 *                             .sentimentType("NEGATIVE")
 *                             .timePeriod(60)
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Transcribe processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeProcessor")
 *                     .amazonTranscribeProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs.builder()
 *                         .contentIdentificationType("PII")
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode("en-US")
 *                         .languageModelName("MyLanguageModel")
 *                         .partialResultsStability("high")
 *                         .piiEntityTypes("ADDRESS,BANK_ACCOUNT_NUMBER")
 *                         .showSpeakerLabel(true)
 *                         .vocabularyFilterMethod("mask")
 *                         .vocabularyFilterName("MyVocabularyFilter")
 *                         .vocabularyName("MyVocabulary")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Voice analytics processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("VoiceAnalyticsProcessor")
 *                     .voiceAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs.builder()
 *                         .speakerSearchStatus("Enabled")
 *                         .voiceToneAnalysisStatus("Enabled")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("LambdaFunctionSink")
 *                     .lambdaFunctionSinkConfiguration(MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:lambda:us-west-2:1111111111:function:MyFunction")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("SnsTopicSink")
 *                     .snsTopicSinkConfiguration(MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:sns:us-west-2:1111111111:topic/MyTopic")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("SqsQueueSink")
 *                     .sqsQueueSinkConfiguration(MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:sqs:us-west-2:1111111111:queue/MyQueue")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.test().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Recording sink usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(MediaInsightsPipelineConfigurationElementArgs.builder()
 *                 .type("S3RecordingSink")
 *                 .s3RecordingSinkConfiguration(MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs.builder()
 *                     .destination("arn:aws:s3:::MyBucket")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime SDK Media Pipelines Media Insights Pipeline Configuration using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration example abcdef123456
 * ```
 *
 */
public class MediaInsightsPipelineConfiguration internal constructor(
    override val javaResource:
    com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration,
) : KotlinCustomResource(javaResource, MediaInsightsPipelineConfigurationMapper) {
    /**
     * ARN of the Media Insights Pipeline Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Collection of processors and sinks to transform media and deliver data.
     */
    public val elements: Output<List<MediaInsightsPipelineConfigurationElement>>
        get() = javaResource.elements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mediaInsightsPipelineConfigurationElementToKotlin(args0)
                })
            })
        })

    /**
     * Configuration name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     */
    public val realTimeAlertConfiguration:
        Output<MediaInsightsPipelineConfigurationRealTimeAlertConfiguration>?
        get() = javaResource.realTimeAlertConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mediaInsightsPipelineConfigurationRealTimeAlertConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
     */
    public val resourceAccessRoleArn: Output<String>
        get() = javaResource.resourceAccessRoleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags for the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MediaInsightsPipelineConfigurationMapper :
    ResourceMapper<MediaInsightsPipelineConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): MediaInsightsPipelineConfiguration =
        MediaInsightsPipelineConfiguration(
            javaResource as
                com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration,
        )
}

/**
 * @see [MediaInsightsPipelineConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MediaInsightsPipelineConfiguration].
 */
public suspend fun mediaInsightsPipelineConfiguration(
    name: String,
    block: suspend MediaInsightsPipelineConfigurationResourceBuilder.() -> Unit,
):
    MediaInsightsPipelineConfiguration {
    val builder = MediaInsightsPipelineConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MediaInsightsPipelineConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mediaInsightsPipelineConfiguration(name: String): MediaInsightsPipelineConfiguration {
    val builder = MediaInsightsPipelineConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
