@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin

import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs.builder
import com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs.MediaInsightsPipelineConfigurationElementArgs
import com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs.MediaInsightsPipelineConfigurationElementArgsBuilder
import com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs
import com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Chime SDK Media Pipelines Media Insights Pipeline Configuration.
 * Consult the [Call analytics developer guide](https://docs.aws.amazon.com/chime-sdk/latest/dg/call-analytics.html) for more detailed information about usage.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stream("example", StreamArgs.builder()
 *             .shardCount(2)
 *             .build());
 *         final var mediaPipelinesAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("mediapipelines.chime.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var callAnalyticsRole = new Role("callAnalyticsRole", RoleArgs.builder()
 *             .assumeRolePolicy(mediaPipelinesAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(callAnalyticsRole.arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(example.arn())
 *                         .build())
 *                     .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Key1", "Value1"),
 *                 Map.entry("Key2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Transcribe Call Analytics processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var transcribeAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transcribe.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var postCallRole = new Role("postCallRole", RoleArgs.builder()
 *             .assumeRolePolicy(transcribeAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .callAnalyticsStreamCategories(
 *                             "category_1",
 *                             "category_2")
 *                         .contentRedactionType("PII")
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode("en-US")
 *                         .languageModelName("MyLanguageModel")
 *                         .partialResultsStability("high")
 *                         .piiEntityTypes("ADDRESS,BANK_ACCOUNT_NUMBER")
 *                         .postCallAnalyticsSettings(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs.builder()
 *                             .contentRedactionOutput("redacted")
 *                             .dataAccessRoleArn(postCallRole.arn())
 *                             .outputEncryptionKmsKeyId("MyKmsKeyId")
 *                             .outputLocation("s3://MyBucket")
 *                             .build())
 *                         .vocabularyFilterMethod("mask")
 *                         .vocabularyFilterName("MyVocabularyFilter")
 *                         .vocabularyName("MyVocabulary")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Real time alerts usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.call_analytics_role().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeCallAnalyticsProcessor")
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode("en-US")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .realTimeAlertConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .rules(
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("IssueDetection")
 *                         .issueDetectionConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs.builder()
 *                             .ruleName("MyIssueDetectionRule")
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("KeywordMatch")
 *                         .keywordMatchConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs.builder()
 *                             .keywords(
 *                                 "keyword1",
 *                                 "keyword2")
 *                             .negate(false)
 *                             .ruleName("MyKeywordMatchRule")
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type("Sentiment")
 *                         .sentimentConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs.builder()
 *                             .ruleName("MySentimentRule")
 *                             .sentimentType("NEGATIVE")
 *                             .timePeriod(60)
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Transcribe processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("AmazonTranscribeProcessor")
 *                     .amazonTranscribeProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs.builder()
 *                         .contentIdentificationType("PII")
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode("en-US")
 *                         .languageModelName("MyLanguageModel")
 *                         .partialResultsStability("high")
 *                         .piiEntityTypes("ADDRESS,BANK_ACCOUNT_NUMBER")
 *                         .showSpeakerLabel(true)
 *                         .vocabularyFilterMethod("mask")
 *                         .vocabularyFilterName("MyVocabularyFilter")
 *                         .vocabularyName("MyVocabulary")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Voice analytics processor usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("VoiceAnalyticsProcessor")
 *                     .voiceAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs.builder()
 *                         .speakerSearchStatus("Enabled")
 *                         .voiceToneAnalysisStatus("Enabled")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("LambdaFunctionSink")
 *                     .lambdaFunctionSinkConfiguration(MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:lambda:us-west-2:1111111111:function:MyFunction")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("SnsTopicSink")
 *                     .snsTopicSinkConfiguration(MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:sns:us-west-2:1111111111:topic/MyTopic")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("SqsQueueSink")
 *                     .sqsQueueSinkConfiguration(MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs.builder()
 *                         .insightsTarget("arn:aws:sqs:us-west-2:1111111111:queue/MyQueue")
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type("KinesisDataStreamSink")
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.test().arn())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Recording sink usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration("myConfiguration", MediaInsightsPipelineConfigurationArgs.builder()
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(MediaInsightsPipelineConfigurationElementArgs.builder()
 *                 .type("S3RecordingSink")
 *                 .s3RecordingSinkConfiguration(MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs.builder()
 *                     .destination("arn:aws:s3:::MyBucket")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Chime SDK Media Pipelines Media Insights Pipeline Configuration using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration example abcdef123456
 * ```
 * @property elements Collection of processors and sinks to transform media and deliver data.
 * @property name Configuration name.
 * @property realTimeAlertConfiguration Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
 * @property resourceAccessRoleArn ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
 * @property tags Key-value map of tags for the resource.
 */
public data class MediaInsightsPipelineConfigurationArgs(
    public val elements: Output<List<MediaInsightsPipelineConfigurationElementArgs>>? = null,
    public val name: Output<String>? = null,
    public val realTimeAlertConfiguration:
    Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs>? = null,
    public val resourceAccessRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs.builder()
            .elements(
                elements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .realTimeAlertConfiguration(
                realTimeAlertConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceAccessRoleArn(resourceAccessRoleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationArgsBuilder internal constructor() {
    private var elements: Output<List<MediaInsightsPipelineConfigurationElementArgs>>? = null

    private var name: Output<String>? = null

    private var realTimeAlertConfiguration:
        Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs>? = null

    private var resourceAccessRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("bvwempjijshacrdu")
    public suspend
    fun elements(`value`: Output<List<MediaInsightsPipelineConfigurationElementArgs>>) {
        this.elements = value
    }

    @JvmName("xfhqbqbiwhwejdcb")
    public suspend fun elements(
        vararg
        values: Output<MediaInsightsPipelineConfigurationElementArgs>,
    ) {
        this.elements = Output.all(values.asList())
    }

    /**
     * @param values Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("ngskdduuxnkibuse")
    public suspend fun elements(values: List<Output<MediaInsightsPipelineConfigurationElementArgs>>) {
        this.elements = Output.all(values)
    }

    /**
     * @param value Configuration name.
     */
    @JvmName("yegcranncuargfqn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     */
    @JvmName("fyhxnkoyuckgeent")
    public suspend
    fun realTimeAlertConfiguration(`value`: Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs>) {
        this.realTimeAlertConfiguration = value
    }

    /**
     * @param value ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
     */
    @JvmName("cnjpfejuobxaxvsi")
    public suspend fun resourceAccessRoleArn(`value`: Output<String>) {
        this.resourceAccessRoleArn = value
    }

    /**
     * @param value Key-value map of tags for the resource.
     */
    @JvmName("sjtijxrmiaatnooy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("wajanhwgitrgfuts")
    public suspend fun elements(`value`: List<MediaInsightsPipelineConfigurationElementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elements = mapped
    }

    /**
     * @param argument Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("relsyuirvaouerlh")
    public suspend
    fun elements(argument: List<suspend MediaInsightsPipelineConfigurationElementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaInsightsPipelineConfigurationElementArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elements = mapped
    }

    /**
     * @param argument Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("yiccumxfclhnxfmk")
    public suspend fun elements(
        vararg
        argument: suspend MediaInsightsPipelineConfigurationElementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MediaInsightsPipelineConfigurationElementArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elements = mapped
    }

    /**
     * @param argument Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("esuxrcgeivanmshh")
    public suspend
    fun elements(argument: suspend MediaInsightsPipelineConfigurationElementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MediaInsightsPipelineConfigurationElementArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.elements = mapped
    }

    /**
     * @param values Collection of processors and sinks to transform media and deliver data.
     */
    @JvmName("pkrtxnscvhuetluj")
    public suspend fun elements(vararg values: MediaInsightsPipelineConfigurationElementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elements = mapped
    }

    /**
     * @param value Configuration name.
     */
    @JvmName("csmdlkspbjcvkfeq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     */
    @JvmName("wkpmxtiqyosgawuv")
    public suspend
    fun realTimeAlertConfiguration(`value`: MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realTimeAlertConfiguration = mapped
    }

    /**
     * @param argument Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     */
    @JvmName("riouiuobckdkqrou")
    public suspend
    fun realTimeAlertConfiguration(argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.realTimeAlertConfiguration = mapped
    }

    /**
     * @param value ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
     */
    @JvmName("blcavjixvyjcqlfn")
    public suspend fun resourceAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessRoleArn = mapped
    }

    /**
     * @param value Key-value map of tags for the resource.
     */
    @JvmName("eecgfxoptkdfoxdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the resource.
     */
    @JvmName("theietgyskkskaum")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationArgs =
        MediaInsightsPipelineConfigurationArgs(
            elements = elements,
            name = name,
            realTimeAlertConfiguration = realTimeAlertConfiguration,
            resourceAccessRoleArn = resourceAccessRoleArn,
            tags = tags,
        )
}
