@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentRedactionOutput Should output be redacted.
 * @property dataAccessRoleArn ARN of the role used by AWS Transcribe to upload your post call analysis.
 * @property outputEncryptionKmsKeyId ID of the KMS key used to encrypt the output.
 * @property outputLocation The Amazon S3 location where you want your Call Analytics post-call transcription output stored.
 */
public data class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs(
    public val contentRedactionOutput: Output<String>? = null,
    public val dataAccessRoleArn: Output<String>,
    public val outputEncryptionKmsKeyId: Output<String>? = null,
    public val outputLocation: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs.builder()
            .contentRedactionOutput(contentRedactionOutput?.applyValue({ args0 -> args0 }))
            .dataAccessRoleArn(dataAccessRoleArn.applyValue({ args0 -> args0 }))
            .outputEncryptionKmsKeyId(outputEncryptionKmsKeyId?.applyValue({ args0 -> args0 }))
            .outputLocation(outputLocation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgsBuilder
internal constructor() {
    private var contentRedactionOutput: Output<String>? = null

    private var dataAccessRoleArn: Output<String>? = null

    private var outputEncryptionKmsKeyId: Output<String>? = null

    private var outputLocation: Output<String>? = null

    /**
     * @param value Should output be redacted.
     */
    @JvmName("lqvjocydnmjrxngb")
    public suspend fun contentRedactionOutput(`value`: Output<String>) {
        this.contentRedactionOutput = value
    }

    /**
     * @param value ARN of the role used by AWS Transcribe to upload your post call analysis.
     */
    @JvmName("etwhmqdulttydpic")
    public suspend fun dataAccessRoleArn(`value`: Output<String>) {
        this.dataAccessRoleArn = value
    }

    /**
     * @param value ID of the KMS key used to encrypt the output.
     */
    @JvmName("psltkcfymaqpmjoj")
    public suspend fun outputEncryptionKmsKeyId(`value`: Output<String>) {
        this.outputEncryptionKmsKeyId = value
    }

    /**
     * @param value The Amazon S3 location where you want your Call Analytics post-call transcription output stored.
     */
    @JvmName("egfwiplbggjhpqfj")
    public suspend fun outputLocation(`value`: Output<String>) {
        this.outputLocation = value
    }

    /**
     * @param value Should output be redacted.
     */
    @JvmName("uahbchwjyfuiiejl")
    public suspend fun contentRedactionOutput(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentRedactionOutput = mapped
    }

    /**
     * @param value ARN of the role used by AWS Transcribe to upload your post call analysis.
     */
    @JvmName("edmjhtxesypgdwxa")
    public suspend fun dataAccessRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessRoleArn = mapped
    }

    /**
     * @param value ID of the KMS key used to encrypt the output.
     */
    @JvmName("hntyhjfumxekcnte")
    public suspend fun outputEncryptionKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputEncryptionKmsKeyId = mapped
    }

    /**
     * @param value The Amazon S3 location where you want your Call Analytics post-call transcription output stored.
     */
    @JvmName("tdjtkgdkrxdbpmxa")
    public suspend fun outputLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputLocation = mapped
    }

    internal fun build():
        MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs =
        MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs(
            contentRedactionOutput = contentRedactionOutput,
            dataAccessRoleArn = dataAccessRoleArn ?: throw PulumiNullFieldException("dataAccessRoleArn"),
            outputEncryptionKmsKeyId = outputEncryptionKmsKeyId,
            outputLocation = outputLocation ?: throw PulumiNullFieldException("outputLocation"),
        )
}
