@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentIdentificationType Labels all personally identifiable information (PII) identified in Transcript events.
 * @property contentRedactionType Redacts all personally identifiable information (PII) identified in Transcript events.
 * @property enablePartialResultsStabilization Enables partial result stabilization in Transcript events.
 * @property filterPartialResults Filters partial Utterance events from delivery to the insights target.
 * @property languageCode Language code for the transcription model.
 * @property languageModelName Name of custom language model for transcription.
 * @property partialResultsStability Level of stability to use when partial results stabilization is enabled.
 * @property piiEntityTypes Types of personally identifiable information (PII) to redact from a Transcript event.
 * @property showSpeakerLabel Enables speaker partitioning (diarization) in your Transcript events.
 * @property vocabularyFilterMethod Method for applying a vocabulary filter to Transcript events.
 * @property vocabularyFilterName Name of the custom vocabulary filter to use when processing Transcript events.
 * @property vocabularyName Name of the custom vocabulary to use when processing Transcript events.
 */
public data class
MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs(
    public val contentIdentificationType: Output<String>? = null,
    public val contentRedactionType: Output<String>? = null,
    public val enablePartialResultsStabilization: Output<Boolean>? = null,
    public val filterPartialResults: Output<Boolean>? = null,
    public val languageCode: Output<String>,
    public val languageModelName: Output<String>? = null,
    public val partialResultsStability: Output<String>? = null,
    public val piiEntityTypes: Output<String>? = null,
    public val showSpeakerLabel: Output<Boolean>? = null,
    public val vocabularyFilterMethod: Output<String>? = null,
    public val vocabularyFilterName: Output<String>? = null,
    public val vocabularyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs.builder()
            .contentIdentificationType(contentIdentificationType?.applyValue({ args0 -> args0 }))
            .contentRedactionType(contentRedactionType?.applyValue({ args0 -> args0 }))
            .enablePartialResultsStabilization(
                enablePartialResultsStabilization?.applyValue({ args0 ->
                    args0
                }),
            )
            .filterPartialResults(filterPartialResults?.applyValue({ args0 -> args0 }))
            .languageCode(languageCode.applyValue({ args0 -> args0 }))
            .languageModelName(languageModelName?.applyValue({ args0 -> args0 }))
            .partialResultsStability(partialResultsStability?.applyValue({ args0 -> args0 }))
            .piiEntityTypes(piiEntityTypes?.applyValue({ args0 -> args0 }))
            .showSpeakerLabel(showSpeakerLabel?.applyValue({ args0 -> args0 }))
            .vocabularyFilterMethod(vocabularyFilterMethod?.applyValue({ args0 -> args0 }))
            .vocabularyFilterName(vocabularyFilterName?.applyValue({ args0 -> args0 }))
            .vocabularyName(vocabularyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgsBuilder
internal constructor() {
    private var contentIdentificationType: Output<String>? = null

    private var contentRedactionType: Output<String>? = null

    private var enablePartialResultsStabilization: Output<Boolean>? = null

    private var filterPartialResults: Output<Boolean>? = null

    private var languageCode: Output<String>? = null

    private var languageModelName: Output<String>? = null

    private var partialResultsStability: Output<String>? = null

    private var piiEntityTypes: Output<String>? = null

    private var showSpeakerLabel: Output<Boolean>? = null

    private var vocabularyFilterMethod: Output<String>? = null

    private var vocabularyFilterName: Output<String>? = null

    private var vocabularyName: Output<String>? = null

    /**
     * @param value Labels all personally identifiable information (PII) identified in Transcript events.
     */
    @JvmName("qfwveyhcyiuhuxxt")
    public suspend fun contentIdentificationType(`value`: Output<String>) {
        this.contentIdentificationType = value
    }

    /**
     * @param value Redacts all personally identifiable information (PII) identified in Transcript events.
     */
    @JvmName("eldwllihaoaakwpu")
    public suspend fun contentRedactionType(`value`: Output<String>) {
        this.contentRedactionType = value
    }

    /**
     * @param value Enables partial result stabilization in Transcript events.
     */
    @JvmName("hmwnajvmtbgmnsbc")
    public suspend fun enablePartialResultsStabilization(`value`: Output<Boolean>) {
        this.enablePartialResultsStabilization = value
    }

    /**
     * @param value Filters partial Utterance events from delivery to the insights target.
     */
    @JvmName("rlwasavohffdiwre")
    public suspend fun filterPartialResults(`value`: Output<Boolean>) {
        this.filterPartialResults = value
    }

    /**
     * @param value Language code for the transcription model.
     */
    @JvmName("rwfmmmodljcprbjx")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Name of custom language model for transcription.
     */
    @JvmName("mylqtudspltowokv")
    public suspend fun languageModelName(`value`: Output<String>) {
        this.languageModelName = value
    }

    /**
     * @param value Level of stability to use when partial results stabilization is enabled.
     */
    @JvmName("cimemqgqrlnxigka")
    public suspend fun partialResultsStability(`value`: Output<String>) {
        this.partialResultsStability = value
    }

    /**
     * @param value Types of personally identifiable information (PII) to redact from a Transcript event.
     */
    @JvmName("ecvslwnhryldlcrh")
    public suspend fun piiEntityTypes(`value`: Output<String>) {
        this.piiEntityTypes = value
    }

    /**
     * @param value Enables speaker partitioning (diarization) in your Transcript events.
     */
    @JvmName("jgqyddfumhvegoxk")
    public suspend fun showSpeakerLabel(`value`: Output<Boolean>) {
        this.showSpeakerLabel = value
    }

    /**
     * @param value Method for applying a vocabulary filter to Transcript events.
     */
    @JvmName("iocmurabsgabnhsu")
    public suspend fun vocabularyFilterMethod(`value`: Output<String>) {
        this.vocabularyFilterMethod = value
    }

    /**
     * @param value Name of the custom vocabulary filter to use when processing Transcript events.
     */
    @JvmName("gxenqaoylqvnoefp")
    public suspend fun vocabularyFilterName(`value`: Output<String>) {
        this.vocabularyFilterName = value
    }

    /**
     * @param value Name of the custom vocabulary to use when processing Transcript events.
     */
    @JvmName("yurwudhxagguwmph")
    public suspend fun vocabularyName(`value`: Output<String>) {
        this.vocabularyName = value
    }

    /**
     * @param value Labels all personally identifiable information (PII) identified in Transcript events.
     */
    @JvmName("ahphcunsncpgdhov")
    public suspend fun contentIdentificationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentIdentificationType = mapped
    }

    /**
     * @param value Redacts all personally identifiable information (PII) identified in Transcript events.
     */
    @JvmName("bgkrjydaqhybodwu")
    public suspend fun contentRedactionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentRedactionType = mapped
    }

    /**
     * @param value Enables partial result stabilization in Transcript events.
     */
    @JvmName("ohklyhamfgshagbs")
    public suspend fun enablePartialResultsStabilization(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartialResultsStabilization = mapped
    }

    /**
     * @param value Filters partial Utterance events from delivery to the insights target.
     */
    @JvmName("tftcqflwtqwkawbr")
    public suspend fun filterPartialResults(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPartialResults = mapped
    }

    /**
     * @param value Language code for the transcription model.
     */
    @JvmName("upudfnrhomndjfnj")
    public suspend fun languageCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Name of custom language model for transcription.
     */
    @JvmName("hicgxfnjwvbxjefk")
    public suspend fun languageModelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageModelName = mapped
    }

    /**
     * @param value Level of stability to use when partial results stabilization is enabled.
     */
    @JvmName("tjywhlworbvswplp")
    public suspend fun partialResultsStability(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partialResultsStability = mapped
    }

    /**
     * @param value Types of personally identifiable information (PII) to redact from a Transcript event.
     */
    @JvmName("vvitjynuouoyjtgy")
    public suspend fun piiEntityTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.piiEntityTypes = mapped
    }

    /**
     * @param value Enables speaker partitioning (diarization) in your Transcript events.
     */
    @JvmName("ypfdbjdsnetknwgt")
    public suspend fun showSpeakerLabel(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.showSpeakerLabel = mapped
    }

    /**
     * @param value Method for applying a vocabulary filter to Transcript events.
     */
    @JvmName("mrdqfensjmctwves")
    public suspend fun vocabularyFilterMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterMethod = mapped
    }

    /**
     * @param value Name of the custom vocabulary filter to use when processing Transcript events.
     */
    @JvmName("jsiwdwfhpsngiylk")
    public suspend fun vocabularyFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterName = mapped
    }

    /**
     * @param value Name of the custom vocabulary to use when processing Transcript events.
     */
    @JvmName("bvowevgmonpfhctu")
    public suspend fun vocabularyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyName = mapped
    }

    internal fun build():
        MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs =
        MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs(
            contentIdentificationType = contentIdentificationType,
            contentRedactionType = contentRedactionType,
            enablePartialResultsStabilization = enablePartialResultsStabilization,
            filterPartialResults = filterPartialResults,
            languageCode = languageCode ?: throw PulumiNullFieldException("languageCode"),
            languageModelName = languageModelName,
            partialResultsStability = partialResultsStability,
            piiEntityTypes = piiEntityTypes,
            showSpeakerLabel = showSpeakerLabel,
            vocabularyFilterMethod = vocabularyFilterMethod,
            vocabularyFilterName = vocabularyFilterName,
            vocabularyName = vocabularyName,
        )
}
