@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination S3 URI to deliver recordings.
 */
public data class MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs(
    public val destination: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgsBuilder
internal constructor() {
    private var destination: Output<String>? = null

    /**
     * @param value S3 URI to deliver recordings.
     */
    @JvmName("cbdnvcefyoyowfcf")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value S3 URI to deliver recordings.
     */
    @JvmName("twpiskafkqcaqwqk")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs =
        MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs(
            destination = destination,
        )
}
