@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property issueDetectionConfiguration Configuration for an issue detection rule.
 * @property keywordMatchConfiguration Configuration for a keyword match rule.
 * @property sentimentConfiguration Configuration for a sentiment rule.
 * @property type Element type.
 */
public data class MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs(
    public val issueDetectionConfiguration:
    Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs>? =
        null,
    public val keywordMatchConfiguration:
    Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs>? =
        null,
    public val sentimentConfiguration:
    Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs>? =
        null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
            .issueDetectionConfiguration(
                issueDetectionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keywordMatchConfiguration(
                keywordMatchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sentimentConfiguration(
                sentimentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs].
 */
@PulumiTagMarker
public class MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgsBuilder internal
constructor() {
    private var issueDetectionConfiguration:
        Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs>? =
        null

    private var keywordMatchConfiguration:
        Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs>? =
        null

    private var sentimentConfiguration:
        Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Configuration for an issue detection rule.
     */
    @JvmName("wbckvfxtcxeiinnt")
    public suspend
    fun issueDetectionConfiguration(`value`: Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs>) {
        this.issueDetectionConfiguration = value
    }

    /**
     * @param value Configuration for a keyword match rule.
     */
    @JvmName("dyjvanschttaordg")
    public suspend
    fun keywordMatchConfiguration(`value`: Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs>) {
        this.keywordMatchConfiguration = value
    }

    /**
     * @param value Configuration for a sentiment rule.
     */
    @JvmName("cenmqopdfkvkqtkp")
    public suspend
    fun sentimentConfiguration(`value`: Output<MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs>) {
        this.sentimentConfiguration = value
    }

    /**
     * @param value Element type.
     */
    @JvmName("jeeduomxgciqbrke")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration for an issue detection rule.
     */
    @JvmName("duejefkkhpansgld")
    public suspend
    fun issueDetectionConfiguration(`value`: MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueDetectionConfiguration = mapped
    }

    /**
     * @param argument Configuration for an issue detection rule.
     */
    @JvmName("ycetxnqrkidobcme")
    public suspend
    fun issueDetectionConfiguration(argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.issueDetectionConfiguration = mapped
    }

    /**
     * @param value Configuration for a keyword match rule.
     */
    @JvmName("suagjitactjywhuu")
    public suspend
    fun keywordMatchConfiguration(`value`: MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keywordMatchConfiguration = mapped
    }

    /**
     * @param argument Configuration for a keyword match rule.
     */
    @JvmName("xtsasdiuofquyvmw")
    public suspend
    fun keywordMatchConfiguration(argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.keywordMatchConfiguration = mapped
    }

    /**
     * @param value Configuration for a sentiment rule.
     */
    @JvmName("rautkwgkjxwpivrm")
    public suspend
    fun sentimentConfiguration(`value`: MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sentimentConfiguration = mapped
    }

    /**
     * @param argument Configuration for a sentiment rule.
     */
    @JvmName("gacjgelpcbfbiwmh")
    public suspend
    fun sentimentConfiguration(argument: suspend MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sentimentConfiguration = mapped
    }

    /**
     * @param value Element type.
     */
    @JvmName("jeitbigkvxoukhns")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs =
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs(
            issueDetectionConfiguration = issueDetectionConfiguration,
            keywordMatchConfiguration = keywordMatchConfiguration,
            sentimentConfiguration = sentimentConfiguration,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
