@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property keywords Collection of keywords to match.
 * @property negate Negate the rule.
 * @property ruleName Rule name.
 */
public data class
MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs(
    public val keywords: Output<List<String>>,
    public val negate: Output<Boolean>? = null,
    public val ruleName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs.builder()
            .keywords(keywords.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .negate(negate?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgsBuilder
internal constructor() {
    private var keywords: Output<List<String>>? = null

    private var negate: Output<Boolean>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value Collection of keywords to match.
     */
    @JvmName("spgtrhtyioanatck")
    public suspend fun keywords(`value`: Output<List<String>>) {
        this.keywords = value
    }

    @JvmName("kuxqunimcmtpyath")
    public suspend fun keywords(vararg values: Output<String>) {
        this.keywords = Output.all(values.asList())
    }

    /**
     * @param values Collection of keywords to match.
     */
    @JvmName("mpsidxccwbwvodxo")
    public suspend fun keywords(values: List<Output<String>>) {
        this.keywords = Output.all(values)
    }

    /**
     * @param value Negate the rule.
     */
    @JvmName("yuorvamybssaqyra")
    public suspend fun negate(`value`: Output<Boolean>) {
        this.negate = value
    }

    /**
     * @param value Rule name.
     */
    @JvmName("ohqnmccfvhcpkknv")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Collection of keywords to match.
     */
    @JvmName("vltxkupawnlpikcp")
    public suspend fun keywords(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param values Collection of keywords to match.
     */
    @JvmName("fvhdvkbjnuuuspdt")
    public suspend fun keywords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param value Negate the rule.
     */
    @JvmName("pcoxlybrmywnqxei")
    public suspend fun negate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negate = mapped
    }

    /**
     * @param value Rule name.
     */
    @JvmName("hlwlbbojlsurybix")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build():
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs =
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs(
            keywords = keywords ?: throw PulumiNullFieldException("keywords"),
            negate = negate,
            ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        )
}
