@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.inputs

import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ruleName Rule name.
 * @property sentimentType Sentiment type to match.
 * @property timePeriod Analysis interval.
 */
public data class
MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs(
    public val ruleName: Output<String>,
    public val sentimentType: Output<String>,
    public val timePeriod: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs =
        com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs.builder()
            .ruleName(ruleName.applyValue({ args0 -> args0 }))
            .sentimentType(sentimentType.applyValue({ args0 -> args0 }))
            .timePeriod(timePeriod.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs].
 */
@PulumiTagMarker
public class
MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgsBuilder
internal constructor() {
    private var ruleName: Output<String>? = null

    private var sentimentType: Output<String>? = null

    private var timePeriod: Output<Int>? = null

    /**
     * @param value Rule name.
     */
    @JvmName("xigtsbyubsamanjn")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Sentiment type to match.
     */
    @JvmName("ptqbqekygrdxigke")
    public suspend fun sentimentType(`value`: Output<String>) {
        this.sentimentType = value
    }

    /**
     * @param value Analysis interval.
     */
    @JvmName("cfhildryxdgyopgv")
    public suspend fun timePeriod(`value`: Output<Int>) {
        this.timePeriod = value
    }

    /**
     * @param value Rule name.
     */
    @JvmName("ytlslaxwjcnvjxnw")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Sentiment type to match.
     */
    @JvmName("gwjpgjilevcgaitf")
    public suspend fun sentimentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sentimentType = mapped
    }

    /**
     * @param value Analysis interval.
     */
    @JvmName("hphtwceflxobhwkk")
    public suspend fun timePeriod(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    internal fun build():
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs =
        MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs(
            ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
            sentimentType = sentimentType ?: throw PulumiNullFieldException("sentimentType"),
            timePeriod = timePeriod ?: throw PulumiNullFieldException("timePeriod"),
        )
}
