@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property callAnalyticsStreamCategories Filter for category events to be delivered to insights target.
 * @property contentIdentificationType Labels all personally identifiable information (PII) identified in Transcript events.
 * @property contentRedactionType Redacts all personally identifiable information (PII) identified in Transcript events.
 * @property enablePartialResultsStabilization Enables partial result stabilization in Transcript events.
 * @property filterPartialResults Filters partial Utterance events from delivery to the insights target.
 * @property languageCode Language code for the transcription model.
 * @property languageModelName Name of custom language model for transcription.
 * @property partialResultsStability Level of stability to use when partial results stabilization is enabled.
 * @property piiEntityTypes Types of personally identifiable information (PII) to redact from a Transcript event.
 * @property postCallAnalyticsSettings Settings for post call analytics.
 * @property vocabularyFilterMethod Method for applying a vocabulary filter to Transcript events.
 * @property vocabularyFilterName Name of the custom vocabulary filter to use when processing Transcript events.
 * @property vocabularyName Name of the custom vocabulary to use when processing Transcript events.
 */
public data class
MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration(
    public val callAnalyticsStreamCategories: List<String>? = null,
    public val contentIdentificationType: String? = null,
    public val contentRedactionType: String? = null,
    public val enablePartialResultsStabilization: Boolean? = null,
    public val filterPartialResults: Boolean? = null,
    public val languageCode: String,
    public val languageModelName: String? = null,
    public val partialResultsStability: String? = null,
    public val piiEntityTypes: String? = null,
    public val postCallAnalyticsSettings:
    MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings? =
        null,
    public val vocabularyFilterMethod: String? = null,
    public val vocabularyFilterName: String? = null,
    public val vocabularyName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.chimesdkmediapipelines.outputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration):
            MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration =
            MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfiguration(
                callAnalyticsStreamCategories = javaType.callAnalyticsStreamCategories().map({ args0 -> args0 }),
                contentIdentificationType = javaType.contentIdentificationType().map({ args0 ->
                    args0
                }).orElse(null),
                contentRedactionType = javaType.contentRedactionType().map({ args0 -> args0 }).orElse(null),
                enablePartialResultsStabilization = javaType.enablePartialResultsStabilization().map({ args0 ->
                    args0
                }).orElse(null),
                filterPartialResults = javaType.filterPartialResults().map({ args0 -> args0 }).orElse(null),
                languageCode = javaType.languageCode(),
                languageModelName = javaType.languageModelName().map({ args0 -> args0 }).orElse(null),
                partialResultsStability = javaType.partialResultsStability().map({ args0 -> args0 }).orElse(null),
                piiEntityTypes = javaType.piiEntityTypes().map({ args0 -> args0 }).orElse(null),
                postCallAnalyticsSettings = javaType.postCallAnalyticsSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.chimesdkmediapipelines.kotlin.outputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vocabularyFilterMethod = javaType.vocabularyFilterMethod().map({ args0 -> args0 }).orElse(null),
                vocabularyFilterName = javaType.vocabularyFilterName().map({ args0 -> args0 }).orElse(null),
                vocabularyName = javaType.vocabularyName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
