@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin

import com.pulumi.aws.cleanrooms.CollaborationArgs.builder
import com.pulumi.aws.cleanrooms.kotlin.inputs.CollaborationDataEncryptionMetadataArgs
import com.pulumi.aws.cleanrooms.kotlin.inputs.CollaborationDataEncryptionMetadataArgsBuilder
import com.pulumi.aws.cleanrooms.kotlin.inputs.CollaborationMemberArgs
import com.pulumi.aws.cleanrooms.kotlin.inputs.CollaborationMemberArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Clean Rooms collaboration.  All members included in the definition will be invited to
 * join the collaboration and can create memberships.
 * ## Example Usage
 * ### Collaboration with tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cleanrooms.Collaboration;
 * import com.pulumi.aws.cleanrooms.CollaborationArgs;
 * import com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs;
 * import com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCollaboration = new Collaboration("testCollaboration", CollaborationArgs.builder()
 *             .creatorDisplayName("Creator ")
 *             .creatorMemberAbilities(
 *                 "CAN_QUERY",
 *                 "CAN_RECEIVE_RESULTS")
 *             .dataEncryptionMetadata(CollaborationDataEncryptionMetadataArgs.builder()
 *                 .allowClearText(true)
 *                 .allowDuplicates(true)
 *                 .allowJoinsOnColumnsWithDifferentNames(true)
 *                 .preserveNulls(false)
 *                 .build())
 *             .description("I made this collaboration with Pulumi!")
 *             .members(CollaborationMemberArgs.builder()
 *                 .accountId(123456789012)
 *                 .displayName("Other member")
 *                 .memberAbilities()
 *                 .build())
 *             .queryLogStatus("DISABLED")
 *             .tags(Map.of("Project", "Pulumi"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_cleanrooms_collaboration` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cleanrooms/collaboration:Collaboration collaboration 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property creatorDisplayName The name for the member record for the collaboration creator.
 * @property creatorMemberAbilities The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
 * @property dataEncryptionMetadata a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
 * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
 * field.
 * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
 * boolean field.
 * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
 * n any other Fingerprint column with a different name. This is a boolean field.
 * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
 * or cryptographically processed (false).
 * @property description A description for a collaboration.
 * @property members Additional members of the collaboration which will be invited to join the collaboration.
 * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
 * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
 * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
 * @property name The name of the collaboration.  Collaboration names do not need to be unique.
 * @property queryLogStatus Determines if members of the collaboration can enable query logs within their own.
 * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
 * @property tags Key value pairs which tag the collaboration.
 */
public data class CollaborationArgs(
    public val creatorDisplayName: Output<String>? = null,
    public val creatorMemberAbilities: Output<List<String>>? = null,
    public val dataEncryptionMetadata: Output<CollaborationDataEncryptionMetadataArgs>? = null,
    public val description: Output<String>? = null,
    public val members: Output<List<CollaborationMemberArgs>>? = null,
    public val name: Output<String>? = null,
    public val queryLogStatus: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cleanrooms.CollaborationArgs> {
    override fun toJava(): com.pulumi.aws.cleanrooms.CollaborationArgs =
        com.pulumi.aws.cleanrooms.CollaborationArgs.builder()
            .creatorDisplayName(creatorDisplayName?.applyValue({ args0 -> args0 }))
            .creatorMemberAbilities(
                creatorMemberAbilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dataEncryptionMetadata(
                dataEncryptionMetadata?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .members(
                members?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .queryLogStatus(queryLogStatus?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CollaborationArgs].
 */
@PulumiTagMarker
public class CollaborationArgsBuilder internal constructor() {
    private var creatorDisplayName: Output<String>? = null

    private var creatorMemberAbilities: Output<List<String>>? = null

    private var dataEncryptionMetadata: Output<CollaborationDataEncryptionMetadataArgs>? = null

    private var description: Output<String>? = null

    private var members: Output<List<CollaborationMemberArgs>>? = null

    private var name: Output<String>? = null

    private var queryLogStatus: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name for the member record for the collaboration creator.
     */
    @JvmName("cldbfalxkirkqasy")
    public suspend fun creatorDisplayName(`value`: Output<String>) {
        this.creatorDisplayName = value
    }

    /**
     * @param value The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("wswkcnpopeenftmw")
    public suspend fun creatorMemberAbilities(`value`: Output<List<String>>) {
        this.creatorMemberAbilities = value
    }

    @JvmName("vqwinexoivrwrpxa")
    public suspend fun creatorMemberAbilities(vararg values: Output<String>) {
        this.creatorMemberAbilities = Output.all(values.asList())
    }

    /**
     * @param values The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("pictcpnpjodyxgge")
    public suspend fun creatorMemberAbilities(values: List<Output<String>>) {
        this.creatorMemberAbilities = Output.all(values)
    }

    /**
     * @param value a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     * field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     * boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     * n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     * or cryptographically processed (false).
     */
    @JvmName("vhfahaxfocoayoan")
    public suspend
    fun dataEncryptionMetadata(`value`: Output<CollaborationDataEncryptionMetadataArgs>) {
        this.dataEncryptionMetadata = value
    }

    /**
     * @param value A description for a collaboration.
     */
    @JvmName("qcyopvdeajkdyspf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("ihrgyogtqyksggqv")
    public suspend fun members(`value`: Output<List<CollaborationMemberArgs>>) {
        this.members = value
    }

    @JvmName("twqcovvmmqkpkdiu")
    public suspend fun members(vararg values: Output<CollaborationMemberArgs>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("rqpbwtvgoiwtrwja")
    public suspend fun members(values: List<Output<CollaborationMemberArgs>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value The name of the collaboration.  Collaboration names do not need to be unique.
     */
    @JvmName("htnkatdddjopupdw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines if members of the collaboration can enable query logs within their own.
     * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
     */
    @JvmName("ikkdrxibupjsiohr")
    public suspend fun queryLogStatus(`value`: Output<String>) {
        this.queryLogStatus = value
    }

    /**
     * @param value Key value pairs which tag the collaboration.
     */
    @JvmName("ohmruaarapbpydup")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name for the member record for the collaboration creator.
     */
    @JvmName("xaqlaqbgukwhkhxb")
    public suspend fun creatorDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creatorDisplayName = mapped
    }

    /**
     * @param value The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("ntqbsbwrbtatlqmn")
    public suspend fun creatorMemberAbilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creatorMemberAbilities = mapped
    }

    /**
     * @param values The list of member abilities for the creator of the collaboration.  Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("ruassevkoknkeyhm")
    public suspend fun creatorMemberAbilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.creatorMemberAbilities = mapped
    }

    /**
     * @param value a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     * field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     * boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     * n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     * or cryptographically processed (false).
     */
    @JvmName("etrliiclfomhbgut")
    public suspend fun dataEncryptionMetadata(`value`: CollaborationDataEncryptionMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataEncryptionMetadata = mapped
    }

    /**
     * @param argument a collection of settings which determine how the [c3r client](https://docs.aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration.
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     * field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     * boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     * n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     * or cryptographically processed (false).
     */
    @JvmName("twygaksyyftxregp")
    public suspend
    fun dataEncryptionMetadata(argument: suspend CollaborationDataEncryptionMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = CollaborationDataEncryptionMetadataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataEncryptionMetadata = mapped
    }

    /**
     * @param value A description for a collaboration.
     */
    @JvmName("bkdtstavtthoedqn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("kdgdgexvrpjfralk")
    public suspend fun members(`value`: List<CollaborationMemberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param argument Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("gwhtfwxkbgubcshp")
    public suspend fun members(argument: List<suspend CollaborationMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CollaborationMemberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("pomnldfbtesfsdde")
    public suspend fun members(vararg argument: suspend CollaborationMemberArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CollaborationMemberArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("ymrroibxhkqxupaq")
    public suspend fun members(argument: suspend CollaborationMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CollaborationMemberArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param values Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member.
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member.
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbilities).
     */
    @JvmName("svjqosnjislkkgef")
    public suspend fun members(vararg values: CollaborationMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value The name of the collaboration.  Collaboration names do not need to be unique.
     */
    @JvmName("kducwyifljcrbgth")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines if members of the collaboration can enable query logs within their own.
     * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-queryLogStatus).
     */
    @JvmName("mbaofgxbxtmqdtoq")
    public suspend fun queryLogStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryLogStatus = mapped
    }

    /**
     * @param value Key value pairs which tag the collaboration.
     */
    @JvmName("fiftaofkpodartmc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key value pairs which tag the collaboration.
     */
    @JvmName("bqeaefbdxumiekgm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CollaborationArgs = CollaborationArgs(
        creatorDisplayName = creatorDisplayName,
        creatorMemberAbilities = creatorMemberAbilities,
        dataEncryptionMetadata = dataEncryptionMetadata,
        description = description,
        members = members,
        name = name,
        queryLogStatus = queryLogStatus,
        tags = tags,
    )
}
