@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin

import com.pulumi.aws.cleanrooms.kotlin.outputs.ConfiguredTableTableReference
import com.pulumi.aws.cleanrooms.kotlin.outputs.ConfiguredTableTableReference.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ConfiguredTable].
 */
@PulumiTagMarker
public class ConfiguredTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfiguredTableArgs = ConfiguredTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfiguredTableArgsBuilder.() -> Unit) {
        val builder = ConfiguredTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfiguredTable {
        val builtJavaResource = com.pulumi.aws.cleanrooms.ConfiguredTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfiguredTable(builtJavaResource)
    }
}

/**
 * Provides a AWS Clean Rooms configured table. Configured tables are used to represent references to existing tables in the AWS Glue Data Catalog.
 * ## Example Usage
 * ### Configured table with tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cleanrooms.ConfiguredTable;
 * import com.pulumi.aws.cleanrooms.ConfiguredTableArgs;
 * import com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testConfiguredTable = new ConfiguredTable("testConfiguredTable", ConfiguredTableArgs.builder()
 *             .allowedColumns(
 *                 "column1",
 *                 "column2",
 *                 "column3")
 *             .analysisMethod("DIRECT_QUERY")
 *             .description("I made this table with Pulumi!")
 *             .tableReference(ConfiguredTableTableReferenceArgs.builder()
 *                 .databaseName("example_database")
 *                 .tableName("example_table")
 *                 .build())
 *             .tags(Map.of("Project", "Pulumi"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_cleanrooms_configured_table` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cleanrooms/configuredTable:ConfiguredTable table 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 *
 */
public class ConfiguredTable internal constructor(
    override val javaResource: com.pulumi.aws.cleanrooms.ConfiguredTable,
) : KotlinCustomResource(javaResource, ConfiguredTableMapper) {
    /**
     * The columns of the references table which will be included in the configured table.
     */
    public val allowedColumns: Output<List<String>>
        get() = javaResource.allowedColumns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
     */
    public val analysisMethod: Output<String>
        get() = javaResource.analysisMethod().applyValue({ args0 -> args0 })

    /**
     * The ARN of the configured table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time the configured table was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * A description for the configured table.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the configured table.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A reference to the AWS Glue table which will be used to create the configured table.
     * * `table_reference.database_name` - (Required - Forces new resource) - The name of the AWS Glue database which contains the table.
     * * `table_reference.table_name` - (Required - Forces new resource) - The name of the AWS Glue table which will be used to create the configured table.
     */
    public val tableReference: Output<ConfiguredTableTableReference>
        get() = javaResource.tableReference().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key value pairs which tag the configured table.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The date and time the configured table was last updated.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })
}

public object ConfiguredTableMapper : ResourceMapper<ConfiguredTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cleanrooms.ConfiguredTable::class == javaResource::class

    override fun map(javaResource: Resource): ConfiguredTable = ConfiguredTable(
        javaResource as
            com.pulumi.aws.cleanrooms.ConfiguredTable,
    )
}

/**
 * @see [ConfiguredTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfiguredTable].
 */
public suspend fun configuredTable(
    name: String,
    block: suspend ConfiguredTableResourceBuilder.() -> Unit,
): ConfiguredTable {
    val builder = ConfiguredTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfiguredTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configuredTable(name: String): ConfiguredTable {
    val builder = ConfiguredTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
