@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin

import com.pulumi.aws.cleanrooms.ConfiguredTableArgs.builder
import com.pulumi.aws.cleanrooms.kotlin.inputs.ConfiguredTableTableReferenceArgs
import com.pulumi.aws.cleanrooms.kotlin.inputs.ConfiguredTableTableReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Clean Rooms configured table. Configured tables are used to represent references to existing tables in the AWS Glue Data Catalog.
 * ## Example Usage
 * ### Configured table with tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cleanrooms.ConfiguredTable;
 * import com.pulumi.aws.cleanrooms.ConfiguredTableArgs;
 * import com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testConfiguredTable = new ConfiguredTable("testConfiguredTable", ConfiguredTableArgs.builder()
 *             .allowedColumns(
 *                 "column1",
 *                 "column2",
 *                 "column3")
 *             .analysisMethod("DIRECT_QUERY")
 *             .description("I made this table with Pulumi!")
 *             .tableReference(ConfiguredTableTableReferenceArgs.builder()
 *                 .databaseName("example_database")
 *                 .tableName("example_table")
 *                 .build())
 *             .tags(Map.of("Project", "Pulumi"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_cleanrooms_configured_table` using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:cleanrooms/configuredTable:ConfiguredTable table 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property allowedColumns The columns of the references table which will be included in the configured table.
 * @property analysisMethod The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
 * @property description A description for the configured table.
 * @property name The name of the configured table.
 * @property tableReference A reference to the AWS Glue table which will be used to create the configured table.
 * * `table_reference.database_name` - (Required - Forces new resource) - The name of the AWS Glue database which contains the table.
 * * `table_reference.table_name` - (Required - Forces new resource) - The name of the AWS Glue table which will be used to create the configured table.
 * @property tags Key value pairs which tag the configured table.
 */
public data class ConfiguredTableArgs(
    public val allowedColumns: Output<List<String>>? = null,
    public val analysisMethod: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tableReference: Output<ConfiguredTableTableReferenceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cleanrooms.ConfiguredTableArgs> {
    override fun toJava(): com.pulumi.aws.cleanrooms.ConfiguredTableArgs =
        com.pulumi.aws.cleanrooms.ConfiguredTableArgs.builder()
            .allowedColumns(allowedColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .analysisMethod(analysisMethod?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tableReference(tableReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConfiguredTableArgs].
 */
@PulumiTagMarker
public class ConfiguredTableArgsBuilder internal constructor() {
    private var allowedColumns: Output<List<String>>? = null

    private var analysisMethod: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tableReference: Output<ConfiguredTableTableReferenceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The columns of the references table which will be included in the configured table.
     */
    @JvmName("byfssvfhiyprmuyd")
    public suspend fun allowedColumns(`value`: Output<List<String>>) {
        this.allowedColumns = value
    }

    @JvmName("lebxhrvawytybqye")
    public suspend fun allowedColumns(vararg values: Output<String>) {
        this.allowedColumns = Output.all(values.asList())
    }

    /**
     * @param values The columns of the references table which will be included in the configured table.
     */
    @JvmName("fbcawkknymhhquse")
    public suspend fun allowedColumns(values: List<Output<String>>) {
        this.allowedColumns = Output.all(values)
    }

    /**
     * @param value The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
     */
    @JvmName("lxwtthrmlqrmxong")
    public suspend fun analysisMethod(`value`: Output<String>) {
        this.analysisMethod = value
    }

    /**
     * @param value A description for the configured table.
     */
    @JvmName("nimcbkoaflsdwtle")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the configured table.
     */
    @JvmName("dsuubfjcuyxndvfn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A reference to the AWS Glue table which will be used to create the configured table.
     * * `table_reference.database_name` - (Required - Forces new resource) - The name of the AWS Glue database which contains the table.
     * * `table_reference.table_name` - (Required - Forces new resource) - The name of the AWS Glue table which will be used to create the configured table.
     */
    @JvmName("taqqyfpadwsuwowk")
    public suspend fun tableReference(`value`: Output<ConfiguredTableTableReferenceArgs>) {
        this.tableReference = value
    }

    /**
     * @param value Key value pairs which tag the configured table.
     */
    @JvmName("wouulhbdstijvsap")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The columns of the references table which will be included in the configured table.
     */
    @JvmName("elotpyunabcscaoq")
    public suspend fun allowedColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedColumns = mapped
    }

    /**
     * @param values The columns of the references table which will be included in the configured table.
     */
    @JvmName("hjljvylwroeygner")
    public suspend fun allowedColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedColumns = mapped
    }

    /**
     * @param value The analysis method for the configured table. The only valid value is currently `DIRECT_QUERY`.
     */
    @JvmName("baprmehqnfulvfjb")
    public suspend fun analysisMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analysisMethod = mapped
    }

    /**
     * @param value A description for the configured table.
     */
    @JvmName("tjnpnkuswpvivhbb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the configured table.
     */
    @JvmName("oubminfmqnspoecy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A reference to the AWS Glue table which will be used to create the configured table.
     * * `table_reference.database_name` - (Required - Forces new resource) - The name of the AWS Glue database which contains the table.
     * * `table_reference.table_name` - (Required - Forces new resource) - The name of the AWS Glue table which will be used to create the configured table.
     */
    @JvmName("xnchtiaxiupgqxrq")
    public suspend fun tableReference(`value`: ConfiguredTableTableReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableReference = mapped
    }

    /**
     * @param argument A reference to the AWS Glue table which will be used to create the configured table.
     * * `table_reference.database_name` - (Required - Forces new resource) - The name of the AWS Glue database which contains the table.
     * * `table_reference.table_name` - (Required - Forces new resource) - The name of the AWS Glue table which will be used to create the configured table.
     */
    @JvmName("gmfhxhyxcxravwsc")
    public suspend
    fun tableReference(argument: suspend ConfiguredTableTableReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ConfiguredTableTableReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableReference = mapped
    }

    /**
     * @param value Key value pairs which tag the configured table.
     */
    @JvmName("chvtwahitwekxsxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key value pairs which tag the configured table.
     */
    @JvmName("ssronyyvmegknyjt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConfiguredTableArgs = ConfiguredTableArgs(
        allowedColumns = allowedColumns,
        analysisMethod = analysisMethod,
        description = description,
        name = name,
        tableReference = tableReference,
        tags = tags,
    )
}
