@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin.inputs

import com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName
 * @property tableName
 */
public data class ConfiguredTableTableReferenceArgs(
    public val databaseName: Output<String>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs> {
    override fun toJava(): com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs =
        com.pulumi.aws.cleanrooms.inputs.ConfiguredTableTableReferenceArgs.builder()
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfiguredTableTableReferenceArgs].
 */
@PulumiTagMarker
public class ConfiguredTableTableReferenceArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("oqhbxjgdeybtyomh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value
     */
    @JvmName("mvcfhcuuaqpsckka")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value
     */
    @JvmName("rufkloykvcuutxev")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value
     */
    @JvmName("csokawunxoptivxr")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): ConfiguredTableTableReferenceArgs = ConfiguredTableTableReferenceArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
