@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cleanrooms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId
 * @property displayName
 * @property memberAbilities
 * @property status
 */
public data class CollaborationMember(
    public val accountId: String,
    public val displayName: String,
    public val memberAbilities: List<String>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cleanrooms.outputs.CollaborationMember):
            CollaborationMember = CollaborationMember(
            accountId = javaType.accountId(),
            displayName = javaType.displayName(),
            memberAbilities = javaType.memberAbilities().map({ args0 -> args0 }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
