@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.aws.cloud9.EnvironmentEC2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud9 EC2 Development Environment.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EnvironmentEC2("example", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .build());
 *     }
 * }
 * ```
 * @property automaticStopTimeMinutes The number of minutes until the running instance is shut down after the environment has last been used.
 * @property connectionType The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` and `CONNECT_SSM`. For more information please refer [AWS documentation for Cloud9](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html).
 * @property description The description of the environment.
 * @property imageId The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. Valid values are
 * * `amazonlinux-1-x86_64`
 * * `amazonlinux-2-x86_64`
 * * `ubuntu-18.04-x86_64`
 * * `ubuntu-22.04-x86_64`
 * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64`
 * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
 * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
 * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
 * @property instanceType The type of instance to connect to the environment, e.g., `t2.micro`.
 * @property name The name of the environment.
 * @property ownerArn The ARN of the environment owner. This can be ARN of any AWS IAM principal. Defaults to the environment's creator.
 * @property subnetId The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EnvironmentEC2Args(
    public val automaticStopTimeMinutes: Output<Int>? = null,
    public val connectionType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerArn: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloud9.EnvironmentEC2Args> {
    override fun toJava(): com.pulumi.aws.cloud9.EnvironmentEC2Args =
        com.pulumi.aws.cloud9.EnvironmentEC2Args.builder()
            .automaticStopTimeMinutes(automaticStopTimeMinutes?.applyValue({ args0 -> args0 }))
            .connectionType(connectionType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerArn(ownerArn?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentEC2Args].
 */
@PulumiTagMarker
public class EnvironmentEC2ArgsBuilder internal constructor() {
    private var automaticStopTimeMinutes: Output<Int>? = null

    private var connectionType: Output<String>? = null

    private var description: Output<String>? = null

    private var imageId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerArn: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The number of minutes until the running instance is shut down after the environment has last been used.
     */
    @JvmName("bytsbjcyajviurdq")
    public suspend fun automaticStopTimeMinutes(`value`: Output<Int>) {
        this.automaticStopTimeMinutes = value
    }

    /**
     * @param value The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` and `CONNECT_SSM`. For more information please refer [AWS documentation for Cloud9](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html).
     */
    @JvmName("heksbiwhrhnbtpyv")
    public suspend fun connectionType(`value`: Output<String>) {
        this.connectionType = value
    }

    /**
     * @param value The description of the environment.
     */
    @JvmName("tgwxtmlirfsestqs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. Valid values are
     * * `amazonlinux-1-x86_64`
     * * `amazonlinux-2-x86_64`
     * * `ubuntu-18.04-x86_64`
     * * `ubuntu-22.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
     */
    @JvmName("ffdvsqadmnesoabs")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The type of instance to connect to the environment, e.g., `t2.micro`.
     */
    @JvmName("oppwrutvitpthaws")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("jhpdclxbvaorqiwe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the environment owner. This can be ARN of any AWS IAM principal. Defaults to the environment's creator.
     */
    @JvmName("fosgsapgcbepxrjm")
    public suspend fun ownerArn(`value`: Output<String>) {
        this.ownerArn = value
    }

    /**
     * @param value The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    @JvmName("uvlsiyfvwwgukhcf")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wfrxdeucgseibwch")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of minutes until the running instance is shut down after the environment has last been used.
     */
    @JvmName("srniheitxwtfqcqv")
    public suspend fun automaticStopTimeMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticStopTimeMinutes = mapped
    }

    /**
     * @param value The connection type used for connecting to an Amazon EC2 environment. Valid values are `CONNECT_SSH` and `CONNECT_SSM`. For more information please refer [AWS documentation for Cloud9](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html).
     */
    @JvmName("gxbddsikibvgknsa")
    public suspend fun connectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value The description of the environment.
     */
    @JvmName("oktgnrqdfrqlegdw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. Valid values are
     * * `amazonlinux-1-x86_64`
     * * `amazonlinux-2-x86_64`
     * * `ubuntu-18.04-x86_64`
     * * `ubuntu-22.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
     * * `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
     */
    @JvmName("nhxqypsacafjiogn")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The type of instance to connect to the environment, e.g., `t2.micro`.
     */
    @JvmName("tibdfrohgrupkqxo")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("mfwtmfjrkrvxegeq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the environment owner. This can be ARN of any AWS IAM principal. Defaults to the environment's creator.
     */
    @JvmName("wdtoyhjkbvmdiqvd")
    public suspend fun ownerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerArn = mapped
    }

    /**
     * @param value The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    @JvmName("neacqhcxmrxtotdg")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jqgnbhehcwbmqywp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ubjhmgbqhtchgbvv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentEC2Args = EnvironmentEC2Args(
        automaticStopTimeMinutes = automaticStopTimeMinutes,
        connectionType = connectionType,
        description = description,
        imageId = imageId,
        instanceType = instanceType,
        name = name,
        ownerArn = ownerArn,
        subnetId = subnetId,
        tags = tags,
    )
}
