@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EnvironmentMembership].
 */
@PulumiTagMarker
public class EnvironmentMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentMembershipArgs = EnvironmentMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentMembershipArgsBuilder.() -> Unit) {
        val builder = EnvironmentMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnvironmentMembership {
        val builtJavaResource = com.pulumi.aws.cloud9.EnvironmentMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EnvironmentMembership(builtJavaResource)
    }
}

/**
 * Provides an environment member to an AWS Cloud9 development environment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.cloud9.EnvironmentMembership;
 * import com.pulumi.aws.cloud9.EnvironmentMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testEnvironmentEC2 = new EnvironmentEC2("testEnvironmentEC2", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .build());
 *         var testUser = new User("testUser");
 *         var testEnvironmentMembership = new EnvironmentMembership("testEnvironmentMembership", EnvironmentMembershipArgs.builder()
 *             .environmentId(testEnvironmentEC2.id())
 *             .permissions("read-only")
 *             .userArn(testUser.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloud9 environment membership using the `environment-id#user-arn`. For example:
 * ```sh
 *  $ pulumi import aws:cloud9/environmentMembership:EnvironmentMembership test environment-id#user-arn
 * ```
 *
 */
public class EnvironmentMembership internal constructor(
    override val javaResource: com.pulumi.aws.cloud9.EnvironmentMembership,
) : KotlinCustomResource(javaResource, EnvironmentMembershipMapper) {
    /**
     * The ID of the environment that contains the environment member you want to add.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    public val permissions: Output<String>
        get() = javaResource.permissions().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    public val userArn: Output<String>
        get() = javaResource.userArn().applyValue({ args0 -> args0 })

    /**
     * he user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object EnvironmentMembershipMapper : ResourceMapper<EnvironmentMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloud9.EnvironmentMembership::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentMembership =
        EnvironmentMembership(javaResource as com.pulumi.aws.cloud9.EnvironmentMembership)
}

/**
 * @see [EnvironmentMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentMembership].
 */
public suspend fun environmentMembership(
    name: String,
    block: suspend EnvironmentMembershipResourceBuilder.() -> Unit,
): EnvironmentMembership {
    val builder = EnvironmentMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentMembership(name: String): EnvironmentMembership {
    val builder = EnvironmentMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
