@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloud9.kotlin

import com.pulumi.aws.cloud9.EnvironmentMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an environment member to an AWS Cloud9 development environment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloud9.EnvironmentEC2;
 * import com.pulumi.aws.cloud9.EnvironmentEC2Args;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.cloud9.EnvironmentMembership;
 * import com.pulumi.aws.cloud9.EnvironmentMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testEnvironmentEC2 = new EnvironmentEC2("testEnvironmentEC2", EnvironmentEC2Args.builder()
 *             .instanceType("t2.micro")
 *             .build());
 *         var testUser = new User("testUser");
 *         var testEnvironmentMembership = new EnvironmentMembership("testEnvironmentMembership", EnvironmentMembershipArgs.builder()
 *             .environmentId(testEnvironmentEC2.id())
 *             .permissions("read-only")
 *             .userArn(testUser.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloud9 environment membership using the `environment-id#user-arn`. For example:
 * ```sh
 *  $ pulumi import aws:cloud9/environmentMembership:EnvironmentMembership test environment-id#user-arn
 * ```
 * @property environmentId The ID of the environment that contains the environment member you want to add.
 * @property permissions The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
 * @property userArn The Amazon Resource Name (ARN) of the environment member you want to add.
 */
public data class EnvironmentMembershipArgs(
    public val environmentId: Output<String>? = null,
    public val permissions: Output<String>? = null,
    public val userArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloud9.EnvironmentMembershipArgs> {
    override fun toJava(): com.pulumi.aws.cloud9.EnvironmentMembershipArgs =
        com.pulumi.aws.cloud9.EnvironmentMembershipArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .permissions(permissions?.applyValue({ args0 -> args0 }))
            .userArn(userArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentMembershipArgs].
 */
@PulumiTagMarker
public class EnvironmentMembershipArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var permissions: Output<String>? = null

    private var userArn: Output<String>? = null

    /**
     * @param value The ID of the environment that contains the environment member you want to add.
     */
    @JvmName("xxbigcgotfyfrtjp")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    @JvmName("nydnnadyqlapfxtk")
    public suspend fun permissions(`value`: Output<String>) {
        this.permissions = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    @JvmName("yyojneaygjywneuo")
    public suspend fun userArn(`value`: Output<String>) {
        this.userArn = value
    }

    /**
     * @param value The ID of the environment that contains the environment member you want to add.
     */
    @JvmName("enhqofmyffaojjuf")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The type of environment member permissions you want to associate with this environment member. Allowed values are `read-only` and `read-write` .
     */
    @JvmName("tuhnuslnfsbsnyaf")
    public suspend fun permissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the environment member you want to add.
     */
    @JvmName("emdehbjccjgkefox")
    public suspend fun userArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userArn = mapped
    }

    internal fun build(): EnvironmentMembershipArgs = EnvironmentMembershipArgs(
        environmentId = environmentId,
        permissions = permissions,
        userArn = userArn,
    )
}
