@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudcontrol.kotlin

import com.pulumi.aws.cloudcontrol.CloudcontrolFunctions.getResourcePlain
import com.pulumi.aws.cloudcontrol.kotlin.inputs.GetResourcePlainArgs
import com.pulumi.aws.cloudcontrol.kotlin.inputs.GetResourcePlainArgsBuilder
import com.pulumi.aws.cloudcontrol.kotlin.outputs.GetResourceResult
import com.pulumi.aws.cloudcontrol.kotlin.outputs.GetResourceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object CloudcontrolFunctions {
    /**
     * Provides details for a Cloud Control API Resource. The reading of these resources is proxied through Cloud Control API handlers to the backend service.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cloudcontrol.CloudcontrolFunctions;
     * import com.pulumi.aws.cloudcontrol.inputs.GetResourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CloudcontrolFunctions.getResource(GetResourceArgs.builder()
     *             .identifier("example")
     *             .typeName("AWS::ECS::Cluster")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResource.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: GetResourcePlainArgs): GetResourceResult =
        toKotlin(getResourcePlain(argument.toJava()).await())

    /**
     * @see [getResource].
     * @param identifier Identifier of the CloudFormation resource type. For example, `vpc-12345678`.
     * @param roleArn ARN of the IAM Role to assume for operations.
     * @param typeName CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * The following arguments are optional:
     * @param typeVersionId Identifier of the CloudFormation resource type version.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(
        identifier: String,
        roleArn: String? = null,
        typeName: String,
        typeVersionId: String? = null,
    ): GetResourceResult {
        val argument = GetResourcePlainArgs(
            identifier = identifier,
            roleArn = roleArn,
            typeName = typeName,
            typeVersionId = typeVersionId,
        )
        return toKotlin(getResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getResource].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cloudcontrol&#46;kotlin&#46;inputs&#46;GetResourcePlainArgs].
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: suspend GetResourcePlainArgsBuilder.() -> Unit):
        GetResourceResult {
        val builder = GetResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getResourcePlain(builtArgument.toJava()).await())
    }
}
