@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudcontrol.kotlin

import com.pulumi.aws.cloudcontrol.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Cloud Control API Resource. The configuration and lifecycle handling of these resources is proxied through Cloud Control API handlers to the backend service.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudcontrol.Resource;
 * import com.pulumi.aws.cloudcontrol.ResourceArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Resource("example", ResourceArgs.builder()
 *             .typeName("AWS::ECS::Cluster")
 *             .desiredState(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("ClusterName", "example"),
 *                     jsonProperty("Tags", jsonArray(jsonObject(
 *                         jsonProperty("Key", "CostCenter"),
 *                         jsonProperty("Value", "IT")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * @property desiredState JSON string matching the CloudFormation resource type schema with desired configuration.
 * @property roleArn Amazon Resource Name (ARN) of the IAM Role to assume for operations.
 * @property schema JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
 * @property typeName CloudFormation resource type name. For example, `AWS::EC2::VPC`.
 * The following arguments are optional:
 * @property typeVersionId Identifier of the CloudFormation resource type version.
 */
public data class ResourceArgs(
    public val desiredState: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val schema: Output<String>? = null,
    public val typeName: Output<String>? = null,
    public val typeVersionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudcontrol.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.cloudcontrol.ResourceArgs =
        com.pulumi.aws.cloudcontrol.ResourceArgs.builder()
            .desiredState(desiredState?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .typeName(typeName?.applyValue({ args0 -> args0 }))
            .typeVersionId(typeVersionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var desiredState: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var schema: Output<String>? = null

    private var typeName: Output<String>? = null

    private var typeVersionId: Output<String>? = null

    /**
     * @param value JSON string matching the CloudFormation resource type schema with desired configuration.
     */
    @JvmName("ffdyvaqxctolycgw")
    public suspend fun desiredState(`value`: Output<String>) {
        this.desiredState = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to assume for operations.
     */
    @JvmName("tfcuuhsglifswjhk")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
     */
    @JvmName("eyabjowlqghyylsu")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * The following arguments are optional:
     */
    @JvmName("hsdfvkcbywnxfglc")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Identifier of the CloudFormation resource type version.
     */
    @JvmName("xehrsnkbowiexgwk")
    public suspend fun typeVersionId(`value`: Output<String>) {
        this.typeVersionId = value
    }

    /**
     * @param value JSON string matching the CloudFormation resource type schema with desired configuration.
     */
    @JvmName("uafgrqjedssmtkgv")
    public suspend fun desiredState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to assume for operations.
     */
    @JvmName("bleigvoobrmvsqep")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
     */
    @JvmName("aehliowngraplcbb")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * The following arguments are optional:
     */
    @JvmName("xvshjwgfrtsmfheq")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    /**
     * @param value Identifier of the CloudFormation resource type version.
     */
    @JvmName("rgxmrgowkbklhbak")
    public suspend fun typeVersionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeVersionId = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        desiredState = desiredState,
        roleArn = roleArn,
        schema = schema,
        typeName = typeName,
        typeVersionId = typeVersionId,
    )
}
