@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudcontrol.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identifier
 * @property properties JSON string matching the CloudFormation resource type schema with current configuration.
 * @property roleArn
 * @property typeName
 * @property typeVersionId
 */
public data class GetResourceResult(
    public val id: String,
    public val identifier: String,
    public val properties: String,
    public val roleArn: String? = null,
    public val typeName: String,
    public val typeVersionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudcontrol.outputs.GetResourceResult):
            GetResourceResult = GetResourceResult(
            id = javaType.id(),
            identifier = javaType.identifier(),
            properties = javaType.properties(),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            typeName = javaType.typeName(),
            typeVersionId = javaType.typeVersionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
