@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.kotlin.outputs.CloudFormationTypeLoggingConfig
import com.pulumi.aws.cloudformation.kotlin.outputs.CloudFormationTypeLoggingConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CloudFormationType].
 */
@PulumiTagMarker
public class CloudFormationTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudFormationTypeArgs = CloudFormationTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudFormationTypeArgsBuilder.() -> Unit) {
        val builder = CloudFormationTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CloudFormationType {
        val builtJavaResource =
            com.pulumi.aws.cloudformation.CloudFormationType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudFormationType(builtJavaResource)
    }
}

/**
 * Manages a version of a CloudFormation Type.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.CloudFormationType;
 * import com.pulumi.aws.cloudformation.CloudFormationTypeArgs;
 * import com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CloudFormationType("example", CloudFormationTypeArgs.builder()
 *             .schemaHandlerPackage(String.format("s3://%s/%s", aws_s3_object.example().bucket(),aws_s3_object.example().key()))
 *             .type("RESOURCE")
 *             .typeName("ExampleCompany::ExampleService::ExampleResource")
 *             .loggingConfig(CloudFormationTypeLoggingConfigArgs.builder()
 *                 .logGroupName(aws_cloudwatch_log_group.example().name())
 *                 .logRoleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_cloudformation_type` using the type version Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/cloudFormationType:CloudFormationType example arn:aws:cloudformation:us-east-1:123456789012:type/resource/ExampleCompany-ExampleService-ExampleType/1
 * ```
 *
 */
public class CloudFormationType internal constructor(
    override val javaResource: com.pulumi.aws.cloudformation.CloudFormationType,
) : KotlinCustomResource(javaResource, CloudFormationTypeMapper) {
    /**
     * (Optional) Amazon Resource Name (ARN) of the CloudFormation Type version. See also `type_arn`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Identifier of the CloudFormation Type default version.
     */
    public val defaultVersionId: Output<String>
        get() = javaResource.defaultVersionId().applyValue({ args0 -> args0 })

    /**
     * Deprecation status of the version.
     */
    public val deprecatedStatus: Output<String>
        get() = javaResource.deprecatedStatus().applyValue({ args0 -> args0 })

    /**
     * Description of the version.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * URL of the documentation for the CloudFormation Type.
     */
    public val documentationUrl: Output<String>
        get() = javaResource.documentationUrl().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
     */
    public val executionRoleArn: Output<String>?
        get() = javaResource.executionRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the CloudFormation Type version is the default version.
     */
    public val isDefaultVersion: Output<Boolean>
        get() = javaResource.isDefaultVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing logging configuration.
     */
    public val loggingConfig: Output<CloudFormationTypeLoggingConfig>?
        get() = javaResource.loggingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning behavior of the CloudFormation Type.
     */
    public val provisioningType: Output<String>
        get() = javaResource.provisioningType().applyValue({ args0 -> args0 })

    /**
     * JSON document of the CloudFormation Type schema.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })

    /**
     * URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
     */
    public val schemaHandlerPackage: Output<String>
        get() = javaResource.schemaHandlerPackage().applyValue({ args0 -> args0 })

    /**
     * URL of the source code for the CloudFormation Type.
     */
    public val sourceUrl: Output<String>
        get() = javaResource.sourceUrl().applyValue({ args0 -> args0 })

    /**
     * CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * (Optional) Amazon Resource Name (ARN) of the CloudFormation Type. See also `arn`.
     */
    public val typeArn: Output<String>
        get() = javaResource.typeArn().applyValue({ args0 -> args0 })

    /**
     * CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
     */
    public val typeName: Output<String>
        get() = javaResource.typeName().applyValue({ args0 -> args0 })

    /**
     * (Optional) Identifier of the CloudFormation Type version.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })

    /**
     * Scope of the CloudFormation Type.
     */
    public val visibility: Output<String>
        get() = javaResource.visibility().applyValue({ args0 -> args0 })
}

public object CloudFormationTypeMapper : ResourceMapper<CloudFormationType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cloudformation.CloudFormationType::class == javaResource::class

    override fun map(javaResource: Resource): CloudFormationType = CloudFormationType(
        javaResource as
            com.pulumi.aws.cloudformation.CloudFormationType,
    )
}

/**
 * @see [CloudFormationType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudFormationType].
 */
public suspend fun cloudFormationType(
    name: String,
    block: suspend CloudFormationTypeResourceBuilder.() -> Unit,
): CloudFormationType {
    val builder = CloudFormationTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudFormationType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudFormationType(name: String): CloudFormationType {
    val builder = CloudFormationTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
