@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudformation.kotlin

import com.pulumi.aws.cloudformation.StackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudFormation Stack resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudformation.Stack;
 * import com.pulumi.aws.cloudformation.StackArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var network = new Stack("network", StackArgs.builder()
 *             .parameters(Map.of("VPCCidr", "10.0.0.0/16"))
 *             .templateBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Parameters", jsonObject(
 *                         jsonProperty("VPCCidr", jsonObject(
 *                             jsonProperty("Type", "String"),
 *                             jsonProperty("Default", "10.0.0.0/16"),
 *                             jsonProperty("Description", "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.")
 *                         ))
 *                     )),
 *                     jsonProperty("Resources", jsonObject(
 *                         jsonProperty("myVpc", jsonObject(
 *                             jsonProperty("Type", "AWS::EC2::VPC"),
 *                             jsonProperty("Properties", jsonObject(
 *                                 jsonProperty("CidrBlock", jsonObject(
 *                                     jsonProperty("Ref", "VPCCidr")
 *                                 )),
 *                                 jsonProperty("Tags", jsonArray(jsonObject(
 *                                     jsonProperty("Key", "Name"),
 *                                     jsonProperty("Value", "Primary_CF_VPC")
 *                                 )))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Cloudformation Stacks using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:cloudformation/stack:Stack stack networking-stack
 * ```
 * @property capabilities A list of capabilities.
 * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
 * @property disableRollback Set to true to disable rollback of the stack if stack creation failed.
 * Conflicts with `on_failure`.
 * @property iamRoleArn The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
 * @property name Stack name.
 * @property notificationArns A list of SNS topic ARNs to publish stack related events.
 * @property onFailure Action to be taken if stack creation fails. This must be
 * one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
 * @property parameters A map of Parameter structures that specify input parameters for the stack.
 * @property policyBody Structure containing the stack policy body.
 * Conflicts w/ `policy_url`.
 * @property policyUrl Location of a file containing the stack policy.
 * Conflicts w/ `policy_body`.
 * @property tags Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateBody Structure containing the template body (max size: 51,200 bytes).
 * @property templateUrl Location of a file containing the template body (max size: 460,800 bytes).
 * @property timeoutInMinutes The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
 */
public data class StackArgs(
    public val capabilities: Output<List<String>>? = null,
    public val disableRollback: Output<Boolean>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notificationArns: Output<List<String>>? = null,
    public val onFailure: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val policyBody: Output<String>? = null,
    public val policyUrl: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val timeoutInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudformation.StackArgs> {
    override fun toJava(): com.pulumi.aws.cloudformation.StackArgs =
        com.pulumi.aws.cloudformation.StackArgs.builder()
            .capabilities(capabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .disableRollback(disableRollback?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationArns(notificationArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .onFailure(onFailure?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .policyBody(policyBody?.applyValue({ args0 -> args0 }))
            .policyUrl(policyUrl?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .timeoutInMinutes(timeoutInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackArgs].
 */
@PulumiTagMarker
public class StackArgsBuilder internal constructor() {
    private var capabilities: Output<List<String>>? = null

    private var disableRollback: Output<Boolean>? = null

    private var iamRoleArn: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationArns: Output<List<String>>? = null

    private var onFailure: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var policyBody: Output<String>? = null

    private var policyUrl: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var timeoutInMinutes: Output<Int>? = null

    /**
     * @param value A list of capabilities.
     * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("fhtswxhprsjjfkav")
    public suspend fun capabilities(`value`: Output<List<String>>) {
        this.capabilities = value
    }

    @JvmName("nupsjibgtaatulqa")
    public suspend fun capabilities(vararg values: Output<String>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values A list of capabilities.
     * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("sqjxsbkemdnqthsb")
    public suspend fun capabilities(values: List<Output<String>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value Set to true to disable rollback of the stack if stack creation failed.
     * Conflicts with `on_failure`.
     */
    @JvmName("vrjgxadsottvscfc")
    public suspend fun disableRollback(`value`: Output<Boolean>) {
        this.disableRollback = value
    }

    /**
     * @param value The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     */
    @JvmName("inqqyxesjovkieuu")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value Stack name.
     */
    @JvmName("rtejunajdskyqylk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of SNS topic ARNs to publish stack related events.
     */
    @JvmName("phqxeyopibpmuhqu")
    public suspend fun notificationArns(`value`: Output<List<String>>) {
        this.notificationArns = value
    }

    @JvmName("njeixxlqwnkxynck")
    public suspend fun notificationArns(vararg values: Output<String>) {
        this.notificationArns = Output.all(values.asList())
    }

    /**
     * @param values A list of SNS topic ARNs to publish stack related events.
     */
    @JvmName("tocxbtahctmgtwxh")
    public suspend fun notificationArns(values: List<Output<String>>) {
        this.notificationArns = Output.all(values)
    }

    /**
     * @param value Action to be taken if stack creation fails. This must be
     * one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
     */
    @JvmName("yjynwbgdkxcmfxir")
    public suspend fun onFailure(`value`: Output<String>) {
        this.onFailure = value
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("nkhkugvcpegjlfuh")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Structure containing the stack policy body.
     * Conflicts w/ `policy_url`.
     */
    @JvmName("sfarfcdqpirmmirs")
    public suspend fun policyBody(`value`: Output<String>) {
        this.policyBody = value
    }

    /**
     * @param value Location of a file containing the stack policy.
     * Conflicts w/ `policy_body`.
     */
    @JvmName("ridiroutcbwiwjia")
    public suspend fun policyUrl(`value`: Output<String>) {
        this.policyUrl = value
    }

    /**
     * @param value Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ymejnkrxkyllucmf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Structure containing the template body (max size: 51,200 bytes).
     */
    @JvmName("dmnvwslqjbqhjpjb")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value Location of a file containing the template body (max size: 460,800 bytes).
     */
    @JvmName("gduugbmeaidyvtsi")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
     */
    @JvmName("gcjubqmyuvddgakc")
    public suspend fun timeoutInMinutes(`value`: Output<Int>) {
        this.timeoutInMinutes = value
    }

    /**
     * @param value A list of capabilities.
     * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("mcrqvnnupryxdjga")
    public suspend fun capabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values A list of capabilities.
     * Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("nuqbbkrkysopclra")
    public suspend fun capabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value Set to true to disable rollback of the stack if stack creation failed.
     * Conflicts with `on_failure`.
     */
    @JvmName("gdnkjiseunjhvtvi")
    public suspend fun disableRollback(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableRollback = mapped
    }

    /**
     * @param value The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
     */
    @JvmName("ypeywmvvgdywfsso")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value Stack name.
     */
    @JvmName("gxwhslpbjbburqkm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of SNS topic ARNs to publish stack related events.
     */
    @JvmName("hvrcfcbdwffyqwxu")
    public suspend fun notificationArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationArns = mapped
    }

    /**
     * @param values A list of SNS topic ARNs to publish stack related events.
     */
    @JvmName("qtaxnmqhncdgqguk")
    public suspend fun notificationArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationArns = mapped
    }

    /**
     * @param value Action to be taken if stack creation fails. This must be
     * one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
     */
    @JvmName("lomddxjaglpdquit")
    public suspend fun onFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("echfjqnrbxyljjbq")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("yrayscjireaeaday")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Structure containing the stack policy body.
     * Conflicts w/ `policy_url`.
     */
    @JvmName("ukdgeqxbjyqdttxg")
    public suspend fun policyBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyBody = mapped
    }

    /**
     * @param value Location of a file containing the stack policy.
     * Conflicts w/ `policy_body`.
     */
    @JvmName("kacnoyoxureclwrf")
    public suspend fun policyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyUrl = mapped
    }

    /**
     * @param value Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otvsmqmkrcifspvn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kruhiiouleihynwg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Structure containing the template body (max size: 51,200 bytes).
     */
    @JvmName("ludocpexhpabqtja")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value Location of a file containing the template body (max size: 460,800 bytes).
     */
    @JvmName("moxcumtlpyveosuy")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
     */
    @JvmName("talaoqxlqlyedwet")
    public suspend fun timeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInMinutes = mapped
    }

    internal fun build(): StackArgs = StackArgs(
        capabilities = capabilities,
        disableRollback = disableRollback,
        iamRoleArn = iamRoleArn,
        name = name,
        notificationArns = notificationArns,
        onFailure = onFailure,
        parameters = parameters,
        policyBody = policyBody,
        policyUrl = policyUrl,
        tags = tags,
        templateBody = templateBody,
        templateUrl = templateUrl,
        timeoutInMinutes = timeoutInMinutes,
    )
}
